/*
 * Decompiled with CFR 0.152.
 */
package org.exist.webstart;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.SystemProperties;
import org.exist.util.FileUtils;
import org.exist.webstart.JnlpHelper;
import org.exist.webstart.JnlpJarFiles;

public class JnlpWriter {
    public static final String JAR_MIME_TYPE = "application/x-java-archive";
    public static final String PACK_MIME_TYPE = "application/x-java-pack200";
    public static final String ACCEPT_ENCODING = "accept-encoding";
    public static final String CONTENT_TYPE = "content-type";
    public static final String CONTENT_ENCODING = "content-encoding";
    public static final String PACK200_GZIP_ENCODING = "pack200-gzip";
    private static final Logger LOGGER = LogManager.getLogger(JnlpWriter.class);

    void writeJnlpXML(JnlpJarFiles jnlpFiles, HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Writing JNLP file");
        String currentUrl = request.getRequestURL().toString();
        int webstartPos = currentUrl.indexOf("/webstart");
        String existBaseUrl = currentUrl.substring(0, webstartPos);
        String codeBase = existBaseUrl + "/webstart/";
        int counter = 0;
        for (Path jar : jnlpFiles.getAllWebstartJars()) {
            ++counter;
            if (jar != null && Files.exists(jar, new LinkOption[0])) continue;
            response.sendError(500, String.format("Missing Jar file! (%s)", counter));
            return;
        }
        String startUrl = existBaseUrl.replaceFirst("http:", "xmldb:exist:").replaceFirst("https:", "xmldb:exist:").replaceAll("-", "%2D") + "/xmlrpc";
        response.setContentType("application/x-java-jnlp-file");
        try {
            XMLStreamWriter writer = XMLOutputFactory.newInstance().createXMLStreamWriter((OutputStream)response.getOutputStream());
            writer.writeStartDocument();
            writer.writeStartElement("jnlp");
            writer.writeAttribute("spec", "7.0");
            writer.writeAttribute("codebase", codeBase);
            writer.writeAttribute("href", "exist.jnlp");
            String version = SystemProperties.getInstance().getSystemProperty("product-version", null);
            if (version != null) {
                writer.writeAttribute("version", version);
            }
            writer.writeStartElement("information");
            writer.writeStartElement("title");
            writer.writeCharacters("eXist XML-DB client");
            writer.writeEndElement();
            writer.writeStartElement("vendor");
            writer.writeCharacters("exist-db.org");
            writer.writeEndElement();
            writer.writeStartElement("homepage");
            writer.writeAttribute("href", "http://exist-db.org");
            writer.writeEndElement();
            writer.writeStartElement("description");
            writer.writeCharacters("Integrated command-line and gui client, entirely based on the XML:DB API and provides commands for most database related tasks, like creating and removing collections, user management, batch-loading XML data or querying.");
            writer.writeEndElement();
            writer.writeStartElement("description");
            writer.writeAttribute("kind", "short");
            writer.writeCharacters("eXist XML-DB client");
            writer.writeEndElement();
            writer.writeStartElement("description");
            writer.writeAttribute("kind", "tooltip");
            writer.writeCharacters("eXist XML-DB client");
            writer.writeEndElement();
            writer.writeStartElement("icon");
            writer.writeAttribute("href", "jnlp_logo.jpg");
            writer.writeEndElement();
            writer.writeStartElement("icon");
            writer.writeAttribute("href", "jnlp_icon_128x128.gif");
            writer.writeAttribute("width", "128");
            writer.writeAttribute("height", "128");
            writer.writeEndElement();
            writer.writeStartElement("icon");
            writer.writeAttribute("href", "jnlp_icon_64x64.gif");
            writer.writeAttribute("width", "64");
            writer.writeAttribute("height", "64");
            writer.writeEndElement();
            writer.writeStartElement("icon");
            writer.writeAttribute("href", "jnlp_icon_32x32.gif");
            writer.writeAttribute("width", "32");
            writer.writeAttribute("height", "32");
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeStartElement("security");
            writer.writeEmptyElement("all-permissions");
            writer.writeEndElement();
            writer.writeStartElement("resources");
            writer.writeStartElement("property");
            writer.writeAttribute("name", "jnlp.packEnabled");
            writer.writeAttribute("value", "true");
            writer.writeEndElement();
            writer.writeStartElement("property");
            writer.writeAttribute("name", "java.util.logging.manager");
            writer.writeAttribute("value", "org.apache.logging.log4j.jul.LogManager");
            writer.writeEndElement();
            writer.writeStartElement("java");
            writer.writeAttribute("version", "1.8+");
            writer.writeEndElement();
            for (Path jar : jnlpFiles.getAllWebstartJars()) {
                writer.writeStartElement("jar");
                writer.writeAttribute("href", FileUtils.fileName((Path)jar));
                writer.writeAttribute("size", "" + FileUtils.sizeQuietly((Path)jar));
                writer.writeEndElement();
            }
            writer.writeEndElement();
            writer.writeStartElement("application-desc");
            writer.writeAttribute("main-class", "org.exist.client.InteractiveClient");
            writer.writeStartElement("argument");
            writer.writeCharacters("-ouri=" + startUrl);
            writer.writeEndElement();
            writer.writeStartElement("argument");
            writer.writeCharacters("--no-embedded-mode");
            writer.writeEndElement();
            if (request.isSecure()) {
                writer.writeStartElement("argument");
                writer.writeCharacters("--use-ssl");
                writer.writeEndElement();
            }
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeEndDocument();
            writer.flush();
            writer.close();
        }
        catch (Throwable ex) {
            LOGGER.error((Object)ex);
            response.sendError(500, ex.getMessage());
        }
    }

    void sendJar(JnlpJarFiles jnlpFiles, String filename, HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Send jar file " + filename);
        Path localFile = jnlpFiles.getJarFile(filename);
        if (localFile == null || !Files.exists(localFile, new LinkOption[0])) {
            response.sendError(404, "Jar file '" + filename + "' not found.");
            return;
        }
        LOGGER.debug("Actual file " + localFile.toAbsolutePath());
        if (FileUtils.fileName((Path)localFile).endsWith(".jar")) {
            response.setContentType(JAR_MIME_TYPE);
        } else if (FileUtils.fileName((Path)localFile).endsWith(".jar.pack.gz")) {
            response.setHeader(CONTENT_ENCODING, PACK200_GZIP_ENCODING);
            response.setContentType(PACK_MIME_TYPE);
        }
        response.setHeader("Content-Length", Long.toString(FileUtils.sizeQuietly((Path)localFile)));
        response.setDateHeader("Last-Modified", Files.getLastModifiedTime(localFile, new LinkOption[0]).toMillis());
        ServletOutputStream os = response.getOutputStream();
        Files.copy(localFile, (OutputStream)os);
        os.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendImage(JnlpHelper jh, JnlpJarFiles jf, String filename, HttpServletResponse response) throws IOException {
        LOGGER.debug("Send image " + filename);
        String type = this.getImageMimeType(filename);
        InputStream imageInputStream = this.getClass().getResourceAsStream("resources/" + filename);
        if (imageInputStream == null) {
            response.sendError(404, String.format("Image file '%s' not found.", filename));
            return;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)imageInputStream, (OutputStream)baos);
        IOUtils.closeQuietly((InputStream)imageInputStream);
        response.setContentType(type);
        response.setContentLength(baos.size());
        ServletOutputStream os = response.getOutputStream();
        try {
            IOUtils.write((byte[])baos.toByteArray(), (OutputStream)os);
            os.flush();
        }
        catch (IllegalStateException ex) {
            LOGGER.debug(ex.getMessage());
        }
        catch (IOException ex) {
            LOGGER.debug("Ignored IOException for '" + filename + "' " + ex.getMessage());
        }
        finally {
            IOUtils.closeQuietly((OutputStream)os);
        }
    }

    private String getImageMimeType(String filename) {
        String type;
        switch (FilenameUtils.getExtension((String)filename)) {
            case ".gif": {
                type = "image/gif";
                break;
            }
            case ".png": {
                type = "image/png";
                break;
            }
            case ".jpg": 
            case ".jpeg": {
                type = "image/jpeg";
                break;
            }
            default: {
                type = "application/octet-stream";
            }
        }
        return type;
    }
}

