/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.request;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.dom.memtree.DocumentBuilderReceiver;
import org.exist.dom.memtree.MemTreeBuilder;
import org.exist.http.servlets.RequestWrapper;
import org.exist.util.MimeTable;
import org.exist.util.MimeType;
import org.exist.util.io.CachingFilterInputStream;
import org.exist.util.io.FilterInputStreamCache;
import org.exist.util.io.FilterInputStreamCacheFactory;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Variable;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.request.RequestModule;
import org.exist.xquery.value.Base64BinaryValueType;
import org.exist.xquery.value.BinaryValueFromInputStream;
import org.exist.xquery.value.BinaryValueManager;
import org.exist.xquery.value.BinaryValueType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.JavaObjectValue;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;
import org.w3c.dom.Document;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class GetData
extends BasicFunction {
    protected static final Logger logger = LogManager.getLogger(GetData.class);
    public static final FunctionSignature signature = new FunctionSignature(new QName("get-data", "http://exist-db.org/xquery/request", "request"), "Returns the content of a POST request. If the HTTP Content-Type header in the request identifies it as a binary document, then xs:base64Binary is returned. If its not a binary document, we attempt to parse it as XML and return a document-node(). If its not a binary or XML document, any other data type is returned as an xs:string representation or an empty sequence if there is no data to be read.", null, (SequenceType)new FunctionReturnSequenceType(11, 3, "the content of a POST request"));

    public GetData(XQueryContext context) {
        super(context, signature);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        Sequence result;
        block25: {
            RequestModule myModule = (RequestModule)this.context.getModule("http://exist-db.org/xquery/request");
            Variable var = myModule.resolveVariable(RequestModule.REQUEST_VAR);
            if (var == null || var.getValue() == null) {
                throw new XPathException((Expression)this, ErrorCodes.XPDY0002, "No request object found in the current XQuery context.");
            }
            if (var.getValue().getItemType() != 100) {
                throw new XPathException((Expression)this, ErrorCodes.XPDY0002, "Variable $request is not bound to an Java object.");
            }
            JavaObjectValue value = (JavaObjectValue)var.getValue().itemAt(0);
            if (!(value.getObject() instanceof RequestWrapper)) {
                throw new XPathException((Expression)this, ErrorCodes.XPDY0002, "Variable $request is not bound to a Request object.");
            }
            RequestWrapper request = (RequestWrapper)value.getObject();
            if (request.getContentLength() == -1L || request.getContentLength() == 0L) {
                return Sequence.EMPTY_SEQUENCE;
            }
            InputStream isRequest = null;
            result = Sequence.EMPTY_SEQUENCE;
            try {
                isRequest = request.getInputStream();
                if (isRequest == null || request.getContentLength() <= 0L) break block25;
                String contentType = request.getContentType();
                if (contentType != null) {
                    MimeType mimeType;
                    if (contentType.indexOf(";") > -1) {
                        contentType = contentType.substring(0, contentType.indexOf(";"));
                    }
                    if ((mimeType = MimeTable.getInstance().getContentType(contentType)) != null && !mimeType.isXMLType()) {
                        result = BinaryValueFromInputStream.getInstance((BinaryValueManager)this.context, (BinaryValueType)new Base64BinaryValueType(), (InputStream)isRequest);
                    }
                }
                if (result != Sequence.EMPTY_SEQUENCE) break block25;
                InputStream is = null;
                FilterInputStreamCache cache = null;
                try {
                    cache = FilterInputStreamCacheFactory.getCacheInstance((FilterInputStreamCacheFactory.FilterInputStreamCacheConfiguration)new FilterInputStreamCacheFactory.FilterInputStreamCacheConfiguration(){

                        public String getCacheClass() {
                            return (String)GetData.this.context.getBroker().getConfiguration().getProperty("binary.cache.class");
                        }
                    }, (InputStream)isRequest);
                    is = new CachingFilterInputStream(cache);
                    is.mark(Integer.MAX_VALUE);
                    result = this.parseAsXml(is);
                    if (result != Sequence.EMPTY_SEQUENCE) break block25;
                    String encoding = request.getCharacterEncoding();
                    if (encoding == null) {
                        encoding = "UTF-8";
                    }
                    try {
                        is.reset();
                        result = this.parseAsString(is, encoding);
                    }
                    catch (IOException ioe) {
                        throw new XPathException((Expression)this, "An IO exception occurred: " + ioe.getMessage(), (Throwable)ioe);
                    }
                }
                finally {
                    if (cache != null) {
                        try {
                            cache.invalidate();
                        }
                        catch (IOException ioe) {
                            LOG.error(ioe.getMessage(), (Throwable)ioe);
                        }
                    }
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException ioe) {
                            LOG.error(ioe.getMessage(), (Throwable)ioe);
                        }
                    }
                }
            }
            catch (IOException ioe) {
                throw new XPathException((Expression)this, "An IO exception occurred: " + ioe.getMessage(), (Throwable)ioe);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Sequence parseAsXml(InputStream is) {
        Sequence result = Sequence.EMPTY_SEQUENCE;
        XMLReader reader = null;
        this.context.pushDocumentContext();
        try {
            InputSource src = new InputSource((InputStream)new CloseShieldInputStream(is));
            reader = this.context.getBroker().getBrokerPool().getParserPool().borrowXMLReader();
            MemTreeBuilder builder = this.context.getDocumentBuilder();
            DocumentBuilderReceiver receiver = new DocumentBuilderReceiver(builder, true);
            reader.setContentHandler((ContentHandler)receiver);
            reader.setProperty("http://xml.org/sax/properties/lexical-handler", receiver);
            reader.parse(src);
            Document doc = receiver.getDocument();
            result = (NodeValue)doc;
        }
        catch (SAXException sAXException) {
            this.context.popDocumentContext();
            if (reader != null) {
                this.context.getBroker().getBrokerPool().getParserPool().returnXMLReader(reader);
            }
        }
        catch (IOException iOException) {
            this.context.popDocumentContext();
            if (reader != null) {
                this.context.getBroker().getBrokerPool().getParserPool().returnXMLReader(reader);
            }
            {
                catch (Throwable throwable) {
                    this.context.popDocumentContext();
                    if (reader != null) {
                        this.context.getBroker().getBrokerPool().getParserPool().returnXMLReader(reader);
                    }
                    throw throwable;
                }
            }
        }
        this.context.popDocumentContext();
        if (reader != null) {
            this.context.getBroker().getBrokerPool().getParserPool().returnXMLReader(reader);
        }
        return result;
    }

    private Sequence parseAsString(InputStream is, String encoding) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] buf = new byte[4096];
        int read = -1;
        while ((read = is.read(buf)) > -1) {
            bos.write(buf, 0, read);
        }
        String s = new String(bos.toByteArray(), encoding);
        return new StringValue(s);
    }
}

