/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.request;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.http.servlets.RequestWrapper;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Variable;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.request.RequestModule;
import org.exist.xquery.value.AnyURIValue;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.JavaObjectValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class GetURI
extends BasicFunction {
    protected static final Logger logger = LogManager.getLogger(GetURI.class);
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("get-uri", "http://exist-db.org/xquery/request", "request"), "Returns the URI of the current request. This will be the original URI as received from the client. Possible modifications done by the URL rewriter will not be visible.", null, (SequenceType)new FunctionReturnSequenceType(25, 2, "the URI of the request")), new FunctionSignature(new QName("get-effective-uri", "http://exist-db.org/xquery/request", "request"), "Returns the URI of the current request. If the request was forwarded via URL rewriting, the function returns the effective, rewritten URI, not the original URI which was received from the client.", null, (SequenceType)new FunctionReturnSequenceType(25, 2, "the URI of the request"))};

    public GetURI(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        RequestModule myModule = (RequestModule)this.context.getModule("http://exist-db.org/xquery/request");
        Variable var = myModule.resolveVariable(RequestModule.REQUEST_VAR);
        if (var == null || var.getValue() == null) {
            throw new XPathException((Expression)this, ErrorCodes.XPDY0002, "No request object found in the current XQuery context.");
        }
        if (var.getValue().getItemType() != 100) {
            throw new XPathException((Expression)this, ErrorCodes.XPDY0002, "Variable $request is not bound to an Java object.");
        }
        JavaObjectValue value = (JavaObjectValue)var.getValue().itemAt(0);
        if (value.getObject() instanceof RequestWrapper) {
            RequestWrapper wrapper = (RequestWrapper)value.getObject();
            Object attr = wrapper.getAttribute("org.exist.forward.request-uri");
            if (attr == null || this.isCalledAs("get-effective-uri")) {
                return new AnyURIValue(wrapper.getRequestURI());
            }
            return new AnyURIValue(attr.toString());
        }
        throw new XPathException((Expression)this, ErrorCodes.XPDY0002, "Variable $request is not bound to a Request object.");
    }
}

