/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.response;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.http.servlets.ResponseWrapper;
import org.exist.xquery.Dependency;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Variable;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.response.ResponseModule;
import org.exist.xquery.value.DateTimeValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.JavaObjectValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class SetDateHeader
extends Function {
    protected static final Logger logger = LogManager.getLogger(SetDateHeader.class);
    protected static final FunctionParameterSequenceType NAME_PARAM = new FunctionParameterSequenceType("name", 22, 2, "The header name");
    protected static final FunctionParameterSequenceType VALUE_PARAM = new FunctionParameterSequenceType("value", 22, 2, "The header value");
    public static final FunctionSignature signature = new FunctionSignature(new QName("set-date-header", "http://exist-db.org/xquery/response", "response"), "Sets a HTTP Header on the HTTP Response.", new SequenceType[]{NAME_PARAM, VALUE_PARAM}, new SequenceType(11, 1));

    public SetDateHeader(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        ResponseModule myModule;
        Variable var;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start((Expression)this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName((int)this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        if ((var = (myModule = (ResponseModule)this.context.getModule("http://exist-db.org/xquery/response")).resolveVariable(ResponseModule.RESPONSE_VAR)) == null || var.getValue() == null) {
            throw new XPathException((Expression)this, ErrorCodes.XPDY0002, "Response not set");
        }
        if (var.getValue().getItemType() != 100) {
            throw new XPathException((Expression)this, ErrorCodes.XPDY0002, "Variable $response is not bound to a Java object.");
        }
        JavaObjectValue response = (JavaObjectValue)var.getValue().itemAt(0);
        String name = this.getArgument(0).eval(contextSequence, contextItem).getStringValue();
        long value = new DateTimeValue(this.getArgument(1).eval(contextSequence, contextItem).getStringValue()).getDate().getTime();
        if (!(response.getObject() instanceof ResponseWrapper)) {
            throw new XPathException((Expression)this, ErrorCodes.XPDY0002, "Type error: variable $response is not bound to a response object");
        }
        ((ResponseWrapper)response.getObject()).setDateHeader(name, value);
        return Sequence.EMPTY_SEQUENCE;
    }
}

