/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.response;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.EXistException;
import org.exist.dom.QName;
import org.exist.http.servlets.ResponseWrapper;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.storage.serializers.Serializer;
import org.exist.util.serializer.SAXSerializer;
import org.exist.util.serializer.SerializerPool;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Option;
import org.exist.xquery.Variable;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.response.ResponseModule;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.JavaObjectValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class Stream
extends BasicFunction {
    private static final Logger logger = LogManager.getLogger(Stream.class);
    public static final FunctionSignature signature = new FunctionSignature(new QName("stream", "http://exist-db.org/xquery/response", "response"), "Stream can only be used within a servlet context. It directly streams its input to the servlet's output stream. It should thus be the last statement in the XQuery.", new SequenceType[]{new FunctionParameterSequenceType("content", 11, 7, "The source sequence"), new FunctionParameterSequenceType("serialization-options", 22, 2, "The serialization options")}, new SequenceType(11, 1));

    public Stream(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (args[0].isEmpty()) {
            return Sequence.EMPTY_SEQUENCE;
        }
        Sequence inputNode = args[0];
        Properties serializeOptions = new Properties();
        String serOpts = args[1].getStringValue();
        String[] contents = Option.tokenize((String)serOpts);
        for (int i = 0; i < contents.length; ++i) {
            String[] pair = Option.parseKeyValuePair((String)contents[i]);
            if (pair == null) {
                throw new XPathException((Expression)this, "Found invalid serialization option: " + contents[i]);
            }
            logger.info("Setting serialization property: " + pair[0] + " = " + pair[1]);
            serializeOptions.setProperty(pair[0], pair[1]);
        }
        ResponseModule myModule = (ResponseModule)this.context.getModule("http://exist-db.org/xquery/response");
        Variable respVar = myModule.resolveVariable(ResponseModule.RESPONSE_VAR);
        if (respVar == null) {
            throw new XPathException((Expression)this, ErrorCodes.XPDY0002, "No response object found in the current XQuery context.");
        }
        if (respVar.getValue().getItemType() != 100) {
            throw new XPathException((Expression)this, ErrorCodes.XPDY0002, "Variable $response is not bound to an Java object.");
        }
        JavaObjectValue respValue = (JavaObjectValue)respVar.getValue().itemAt(0);
        if (!"org.exist.http.servlets.HttpResponseWrapper".equals(respValue.getObject().getClass().getName())) {
            throw new XPathException((Expression)this, ErrorCodes.XPDY0002, signature.toString() + " can only be used within the EXistServlet or XQueryServlet");
        }
        ResponseWrapper response = (ResponseWrapper)respValue.getObject();
        String mediaType = serializeOptions.getProperty("media-type", "application/xml");
        String encoding = serializeOptions.getProperty("encoding", "UTF-8");
        if (mediaType != null) {
            response.setContentType(mediaType + "; charset=" + encoding);
        }
        Serializer serializer = null;
        try {
            BrokerPool db = BrokerPool.getInstance();
            try (DBBroker broker = db.getBroker();
                 PrintWriter output = new PrintWriter(new OutputStreamWriter(response.getOutputStream(), encoding));){
                serializer = broker.getSerializer();
                serializer.reset();
                SerializerPool serializerPool = SerializerPool.getInstance();
                SAXSerializer sax = (SAXSerializer)serializerPool.borrowObject(SAXSerializer.class);
                try {
                    sax.setOutput((Writer)output, serializeOptions);
                    serializer.setProperties(serializeOptions);
                    serializer.setSAXHandlers((ContentHandler)sax, (LexicalHandler)sax);
                    serializer.toSAX(inputNode, 1, inputNode.getItemCount(), false, false, 0L, 0L);
                }
                catch (SAXException e) {
                    e.printStackTrace();
                    throw new IOException(e);
                }
                finally {
                    serializerPool.returnObject((Object)sax);
                }
                output.flush();
            }
            response.flushBuffer();
        }
        catch (IOException e) {
            throw new XPathException((Expression)this, "IO exception while streaming node: " + e.getMessage(), (Throwable)e);
        }
        catch (EXistException e) {
            throw new XPathException((Expression)this, "Exception while streaming node: " + e.getMessage(), (Throwable)e);
        }
        return Sequence.EMPTY_SEQUENCE;
    }
}

