/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.response;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.http.servlets.ResponseWrapper;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Variable;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.response.ResponseModule;
import org.exist.xquery.value.BinaryValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.JavaObjectValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class StreamBinary
extends BasicFunction {
    protected static final Logger logger = LogManager.getLogger(StreamBinary.class);
    protected static final FunctionParameterSequenceType BINARY_DATA_PARAM = new FunctionParameterSequenceType("binary-data", 26, 2, "The binary data to stream");
    protected static final FunctionParameterSequenceType CONTENT_TYPE_PARAM = new FunctionParameterSequenceType("content-type", 22, 2, "The ContentType HTTP header value");
    protected static final FunctionParameterSequenceType FILENAME_PARAM = new FunctionParameterSequenceType("filename", 22, 3, "The filename.  If provided, a Content-Disposition header is set for the filename in the HTTP Response");
    public static final FunctionSignature signature = new FunctionSignature(new QName("stream-binary", "http://exist-db.org/xquery/response", "response"), "Streams the binary data to the current servlet response output stream. The ContentType HTTP header is set to the value given in $content-type.Note: the servlet output stream will be closed afterwards and mime-type settings in the prolog will not be passed.", new SequenceType[]{BINARY_DATA_PARAM, CONTENT_TYPE_PARAM, FILENAME_PARAM}, new SequenceType(10, 1), true);

    public StreamBinary(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        ResponseModule myModule;
        Variable respVar;
        if (args[0].isEmpty() || args[1].isEmpty()) {
            return Sequence.EMPTY_SEQUENCE;
        }
        BinaryValue binary = (BinaryValue)args[0].itemAt(0);
        String contentType = args[1].getStringValue();
        String filename = null;
        if (args.length > 2 && !args[2].isEmpty()) {
            filename = args[2].getStringValue();
        }
        if ((respVar = (myModule = (ResponseModule)this.context.getModule("http://exist-db.org/xquery/response")).resolveVariable(ResponseModule.RESPONSE_VAR)) == null || respVar.getValue() == null) {
            throw new XPathException((Expression)this, ErrorCodes.XPDY0002, "No response object found in the current XQuery context.");
        }
        if (respVar.getValue().getItemType() != 100) {
            throw new XPathException((Expression)this, ErrorCodes.XPDY0002, "Variable $response is not bound to an Java object.");
        }
        JavaObjectValue respValue = (JavaObjectValue)respVar.getValue().itemAt(0);
        if (!"org.exist.http.servlets.HttpResponseWrapper".equals(respValue.getObject().getClass().getName())) {
            throw new XPathException((Expression)this, ErrorCodes.XPDY0002, signature.toString() + " can only be used within the EXistServlet or XQueryServlet");
        }
        ResponseWrapper response = (ResponseWrapper)respValue.getObject();
        response.setHeader("Content-Type", contentType);
        if (filename != null) {
            response.setHeader("Content-Disposition", "inline; filename=\"" + filename + "\"");
        }
        try {
            OutputStream os = response.getOutputStream();
            binary.streamBinaryTo(response.getOutputStream());
            os.close();
            response.flushBuffer();
        }
        catch (IOException e) {
            throw new XPathException((Expression)this, "IO exception while streaming data: " + e.getMessage(), (Throwable)e);
        }
        return Sequence.EMPTY_SEQUENCE;
    }
}

