/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.session;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.http.servlets.RequestWrapper;
import org.exist.http.servlets.SessionWrapper;
import org.exist.security.AuthenticationException;
import org.exist.security.SecurityManager;
import org.exist.security.Subject;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.UserSwitchingBasicFunction;
import org.exist.xquery.Variable;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.request.RequestModule;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.JavaObjectValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;

public class SetCurrentUser
extends UserSwitchingBasicFunction {
    private static final Logger logger = LogManager.getLogger(SetCurrentUser.class);
    public static final FunctionSignature signature = new FunctionSignature(new QName("set-current-user", "http://exist-db.org/xquery/session", "session"), "Change the user identity for the current HTTP session. Subsequent XQueries in the session will run with the new user identity.", new SequenceType[]{new FunctionParameterSequenceType("user-name", 22, 2, "The user name"), new FunctionParameterSequenceType("password", 22, 2, "The password")}, (SequenceType)new FunctionReturnSequenceType(23, 3, "true if the user name and password represent a valid user"));

    public SetCurrentUser(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        RequestModule myModule = (RequestModule)this.context.getModule("http://exist-db.org/xquery/request");
        Variable var = myModule.resolveVariable(RequestModule.REQUEST_VAR);
        if (var == null || var.getValue() == null) {
            throw new XPathException((Expression)this, ErrorCodes.XPDY0002, "No request object found in the current XQuery context.");
        }
        if (var.getValue().getItemType() != 100) {
            throw new XPathException((Expression)this, ErrorCodes.XPDY0002, "Variable $request is not bound to an Java object.");
        }
        JavaObjectValue value = (JavaObjectValue)var.getValue().itemAt(0);
        if (value.getObject() instanceof RequestWrapper) {
            Subject user;
            RequestWrapper request = (RequestWrapper)value.getObject();
            String userName = args[0].getStringValue();
            String passwd = args[1].getStringValue();
            SecurityManager security = this.context.getBroker().getBrokerPool().getSecurityManager();
            try {
                user = security.authenticate(userName, (Object)passwd);
            }
            catch (AuthenticationException e) {
                logger.warn("Could not validate user " + userName + " [" + e.getMessage() + "]");
                return BooleanValue.FALSE;
            }
            this.switchUser(user);
            SessionWrapper session = request.getSession(true);
            session.setAttribute("user", userName);
            session.setAttribute("password", new StringValue(passwd));
            return BooleanValue.TRUE;
        }
        throw new XPathException((Expression)this, ErrorCodes.XPDY0002, "Variable $request is not bound to a Request object.");
    }
}

