/*
 * Decompiled with CFR 0.152.
 */
package org.exist.extensions.exquery.modules.request;

import org.exist.dom.QName;
import org.exist.extensions.exquery.modules.request.AbstractRequestModuleFunction;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;
import org.exquery.http.HttpRequest;

public class CookieFunctions
extends AbstractRequestModuleFunction {
    private static final QName qnCookie = new QName("cookie", "http://exquery.org/ns/request", "req");
    public static final FunctionSignature FNS_COOKIE = new FunctionSignature(qnCookie, "Gets the value of the named Cookie in the HTTP Request. If there is no such cookie, then an empty sequence is returned.", new SequenceType[]{new FunctionParameterSequenceType("cookie-name", 22, 2, "The name of the cookie to retrieve the value of.")}, (SequenceType)new FunctionReturnSequenceType(22, 3, "The value of the named cookie, or an empty sequence."));
    public static final FunctionSignature FNS_COOKIE_WITH_DEFAULT = new FunctionSignature(qnCookie, "Gets he value of the named Cookie in the HTTP Request. If there is no such cookie in the HTTP Request, then the value specified in $default is returned instead.", new SequenceType[]{new FunctionParameterSequenceType("cookie-name", 22, 2, "The name of the cookie to retrieve the value of."), new FunctionParameterSequenceType("default", 22, 2, "The default value to use if the named cookie is not present in the request.")}, (SequenceType)new FunctionReturnSequenceType(22, 2, "The value of the named cookie, or the default value."));

    public CookieFunctions(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Sequence eval(Sequence[] args, HttpRequest request) throws XPathException {
        if (!this.isCalledAs(qnCookie.getLocalPart())) throw new XPathException((Expression)this, "Unknown function call: " + this.getSignature());
        String cookieName = args[0].getStringValue();
        if (this.getSignature().getArgumentCount() == 1) {
            return this.getCookie(request, cookieName, null);
        }
        if (this.getSignature().getArgumentCount() != 2) throw new XPathException((Expression)this, "Unknown function call: " + this.getSignature());
        Sequence defaultValues = args[1];
        return this.getCookie(request, cookieName, defaultValues);
    }

    private Sequence getCookie(HttpRequest request, String cookieName, Sequence defaultValues) throws XPathException {
        String cookieValue = request.getCookieValue(cookieName);
        Object result = cookieValue == null ? (defaultValues != null ? defaultValues : Sequence.EMPTY_SEQUENCE) : new StringValue(cookieValue);
        return result;
    }
}

