/*
 * Decompiled with CFR 0.152.
 */
package org.exist.extensions.exquery.modules.request;

import org.exist.dom.QName;
import org.exist.extensions.exquery.modules.request.AbstractRequestModuleFunction;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;
import org.exquery.http.HttpRequest;

public class URIFunctions
extends AbstractRequestModuleFunction {
    private static final QName qnScheme = new QName("scheme", "http://exquery.org/ns/request", "req");
    private static final QName qnHostname = new QName("hostname", "http://exquery.org/ns/request", "req");
    private static final QName qnPort = new QName("port", "http://exquery.org/ns/request", "req");
    private static final QName qnPath = new QName("path", "http://exquery.org/ns/request", "req");
    private static final QName qnQuery = new QName("query", "http://exquery.org/ns/request", "req");
    private static final QName qnUri = new QName("uri", "http://exquery.org/ns/request", "req");
    public static final FunctionSignature FNS_SCHEME = new FunctionSignature(qnScheme, "Gets the Scheme of the HTTP Request e.g. https.", null, (SequenceType)new FunctionReturnSequenceType(22, 2, "The Scheme of the HTTP Request."));
    public static final FunctionSignature FNS_HOSTNAME = new FunctionSignature(qnHostname, "Gets the Hostname fragment of the Authority component of the URI of the HTTP Request.", null, (SequenceType)new FunctionReturnSequenceType(22, 2, "The Hostname of the HTTP Request."));
    public static final FunctionSignature FNS_PORT = new FunctionSignature(qnPort, "Gets the Port fragment of the Authority component of the URI of the HTTP Request. If the port is not explicitly specified in the URI, then the default port for the HTTP Scheme is returned (i.e. 21 for FTP, 80 for HTTP and 443 for HTTPS).", null, (SequenceType)new FunctionReturnSequenceType(31, 2, "The Port of the HTTP Request."));
    public static final FunctionSignature FNS_PATH = new FunctionSignature(qnPath, "Gets the Path component of the URI of the HTTP Request.", null, (SequenceType)new FunctionReturnSequenceType(22, 2, "The Path of the URI of the HTTP Request."));
    public static final FunctionSignature FNS_QUERY = new FunctionSignature(qnQuery, "Gets the Query Component of the HTTP Request URI, if there is no query component then an empty sequence is returned.", null, (SequenceType)new FunctionReturnSequenceType(22, 3, "The Query of the URI of the HTTP Request."));
    public static final FunctionSignature FNS_URI = new FunctionSignature(qnUri, "Gets the URI of the HTTP Request URI.", null, (SequenceType)new FunctionReturnSequenceType(22, 3, "The URI of the HTTP Request."));

    public URIFunctions(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence[] args, HttpRequest request) throws XPathException {
        Object result;
        if (this.isCalledAs(qnScheme.getLocalPart())) {
            result = new StringValue(request.getScheme());
        } else if (this.isCalledAs(qnHostname.getLocalPart())) {
            result = new StringValue(request.getHostname());
        } else if (this.isCalledAs(qnPort.getLocalPart())) {
            result = new IntegerValue((long)request.getPort());
        } else if (this.isCalledAs(qnPath.getLocalPart())) {
            result = new StringValue(request.getPath());
        } else if (this.isCalledAs(qnQuery.getLocalPart())) {
            String query = request.getQuery();
            result = query == null ? Sequence.EMPTY_SEQUENCE : new StringValue(query);
        } else if (this.isCalledAs(qnUri.getLocalPart())) {
            result = new StringValue(request.getURI());
        } else {
            throw new XPathException((Expression)this, "Unknown function call: " + this.getSignature());
        }
        return result;
    }
}

