/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing;

import org.apache.sis.math.MathFunctions;
import org.apache.sis.util.Static;

public final class Formulas
extends Static {
    public static final double LINEAR_TOLERANCE = 0.01;
    public static final double ANGULAR_TOLERANCE = 8.999280057595393E-8;
    public static final long JULIAN_YEAR_LENGTH = 31557600000L;

    private Formulas() {
    }

    public static int pow3(int n) {
        assert (n >= 0 && n <= 19) : n;
        int n2 = 1;
        while (--n >= 0) {
            n2 *= 3;
        }
        return n2;
    }

    public static boolean isPoleToPole(double d, double d2) {
        return Math.abs(d - -90.0) <= 8.999280057595393E-8 && Math.abs(d2 - 90.0) <= 8.999280057595393E-8;
    }

    public static double getAuthalicRadius(double d, double d2) {
        if (d != d2) {
            double d3 = 1.0 - d2 / d;
            double d4 = Math.sqrt(2.0 * d3 - d3 * d3);
            return Math.sqrt(0.5 * (d * d + d2 * d2 * MathFunctions.atanh(d4) / d4));
        }
        return d;
    }

    public static double getSemiMinor(double d, double d2) {
        return d * (1.0 - 1.0 / d2);
    }

    public static double getInverseFlattening(double d, double d2) {
        return d / (d - d2);
    }
}

