/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.crs;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.referencing.ReferencingUtilities;
import org.apache.sis.internal.referencing.WKTUtilities;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.io.wkt.Convention;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.crs.AbstractCRS;
import org.apache.sis.referencing.crs.SubTypes;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.referencing.cs.DefaultCompoundCS;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.collection.CheckedContainer;
import org.apache.sis.util.resources.Errors;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.EngineeringCRS;
import org.opengis.referencing.crs.GeodeticCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.datum.Datum;

@XmlType(name="CompoundCRSType")
@XmlRootElement(name="CompoundCRS")
public class DefaultCompoundCRS
extends AbstractCRS
implements CompoundCRS {
    private static final long serialVersionUID = -2656710314586929287L;
    private final List<? extends CoordinateReferenceSystem> components;
    private transient List<SingleCRS> singles;

    public DefaultCompoundCRS(Map<String, ?> map, CoordinateReferenceSystem ... coordinateReferenceSystemArray) {
        super(map, DefaultCompoundCRS.createCoordinateSystem(map, coordinateReferenceSystemArray));
        this.components = this.copy(Arrays.asList(coordinateReferenceSystemArray));
    }

    private static CoordinateSystem createCoordinateSystem(Map<String, ?> map, CoordinateReferenceSystem[] coordinateReferenceSystemArray) {
        ArgumentChecks.ensureNonNull("components", coordinateReferenceSystemArray);
        if (coordinateReferenceSystemArray.length < 2) {
            throw new IllegalArgumentException(Errors.getResources(map).getString((short)104, 2, coordinateReferenceSystemArray.length));
        }
        CoordinateSystem[] coordinateSystemArray = new CoordinateSystem[coordinateReferenceSystemArray.length];
        for (int i = 0; i < coordinateReferenceSystemArray.length; ++i) {
            CoordinateReferenceSystem coordinateReferenceSystem = coordinateReferenceSystemArray[i];
            ArgumentChecks.ensureNonNullElement("components", i, coordinateReferenceSystem);
            coordinateSystemArray[i] = coordinateReferenceSystem.getCoordinateSystem();
        }
        return new DefaultCompoundCS(coordinateSystemArray);
    }

    private boolean computeSingleCRS(List<? extends CoordinateReferenceSystem> list) {
        this.singles = new ArrayList<SingleCRS>(list.size());
        boolean bl = ReferencingUtilities.getSingleComponents(list, this.singles);
        this.singles = UnmodifiableArrayList.wrap(this.singles.toArray(new SingleCRS[this.singles.size()]));
        return bl;
    }

    private List<? extends CoordinateReferenceSystem> copy(List<? extends CoordinateReferenceSystem> list) {
        list = this.computeSingleCRS(list) ? this.singles : UnmodifiableArrayList.wrap(list.toArray(new CoordinateReferenceSystem[list.size()]));
        return list;
    }

    protected DefaultCompoundCRS(CompoundCRS compoundCRS) {
        super(compoundCRS);
        if (compoundCRS instanceof DefaultCompoundCRS) {
            DefaultCompoundCRS defaultCompoundCRS = (DefaultCompoundCRS)compoundCRS;
            this.components = defaultCompoundCRS.components;
            this.singles = defaultCompoundCRS.singles;
        } else {
            this.components = this.copy(compoundCRS.getComponents());
        }
    }

    public static DefaultCompoundCRS castOrCopy(CompoundCRS compoundCRS) {
        return compoundCRS == null || compoundCRS instanceof DefaultCompoundCRS ? (DefaultCompoundCRS)compoundCRS : new DefaultCompoundCRS(compoundCRS);
    }

    public Class<? extends CompoundCRS> getInterface() {
        return CompoundCRS.class;
    }

    @Override
    final Datum getDatum() {
        return null;
    }

    @Override
    public List<CoordinateReferenceSystem> getComponents() {
        return this.components;
    }

    public List<SingleCRS> getSingleComponents() {
        return this.singles;
    }

    final boolean isStandardCompliant() {
        int n = 0;
        block9: for (SingleCRS singleCRS : this.getSingleComponents()) {
            switch (n) {
                case 0: {
                    if (singleCRS instanceof GeodeticCRS || singleCRS instanceof ProjectedCRS || singleCRS instanceof EngineeringCRS) {
                        switch (singleCRS.getCoordinateSystem().getDimension()) {
                            case 2: {
                                n = 1;
                                continue block9;
                            }
                            case 3: {
                                n = 2;
                                continue block9;
                            }
                        }
                    }
                    return false;
                }
                case 1: {
                    if (singleCRS instanceof VerticalCRS) {
                        n = 2;
                        continue block9;
                    }
                }
                case 2: {
                    if (!(singleCRS instanceof TemporalCRS)) break;
                    n = 3;
                    continue block9;
                }
            }
            return false;
        }
        return true;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Class clazz;
        objectInputStream.defaultReadObject();
        if (this.components instanceof CheckedContainer && (clazz = ((CheckedContainer)((Object)this.components)).getElementType()) == SingleCRS.class) {
            this.singles = this.components;
            return;
        }
        this.computeSingleCRS(this.components);
    }

    @Override
    public synchronized DefaultCompoundCRS forConvention(AxesConvention axesConvention) {
        ArgumentChecks.ensureNonNull("convention", axesConvention);
        DefaultCompoundCRS defaultCompoundCRS = (DefaultCompoundCRS)this.getCached(axesConvention);
        if (defaultCompoundCRS == null) {
            defaultCompoundCRS = this;
            boolean bl = false;
            boolean bl2 = axesConvention.ordinal() <= AxesConvention.CONVENTIONALLY_ORIENTED.ordinal();
            List<CoordinateReferenceSystem> list = bl2 ? this.singles : this.components;
            CoordinateReferenceSystem[] coordinateReferenceSystemArray = new CoordinateReferenceSystem[list.size()];
            for (int i = 0; i < coordinateReferenceSystemArray.length; ++i) {
                CoordinateReferenceSystem coordinateReferenceSystem = list.get(i);
                AbstractCRS abstractCRS = DefaultCompoundCRS.castOrCopy(coordinateReferenceSystem);
                if (abstractCRS != (abstractCRS = abstractCRS.forConvention(axesConvention))) {
                    coordinateReferenceSystem = abstractCRS;
                    bl = true;
                }
                coordinateReferenceSystemArray[i] = coordinateReferenceSystem;
            }
            if (bl) {
                if (bl2) {
                    Arrays.sort(coordinateReferenceSystemArray, SubTypes.BY_TYPE);
                }
                defaultCompoundCRS = new DefaultCompoundCRS(IdentifiedObjects.getProperties(this, "identifiers"), coordinateReferenceSystemArray);
            }
            defaultCompoundCRS = (DefaultCompoundCRS)this.setCached(axesConvention, defaultCompoundCRS);
        }
        return defaultCompoundCRS;
    }

    @Override
    final AbstractCRS createSameType(Map<String, ?> map, CoordinateSystem coordinateSystem) {
        throw new AssertionError();
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, comparisonMode)) {
            switch (comparisonMode) {
                case STRICT: {
                    return this.components.equals(((DefaultCompoundCRS)object).components);
                }
            }
            return Utilities.deepEquals(this.getComponents(), ((CompoundCRS)object).getComponents(), comparisonMode);
        }
        return false;
    }

    @Override
    protected long computeHashCode() {
        return super.computeHashCode() + (long)(31 * this.components.hashCode());
    }

    @Override
    protected String formatTo(Formatter formatter) {
        WKTUtilities.appendName(this, formatter, null);
        Convention convention = formatter.getConvention();
        boolean bl = convention.majorVersion() == 1;
        for (CoordinateReferenceSystem coordinateReferenceSystem : bl || convention == Convention.INTERNAL ? this.getComponents() : this.getSingleComponents()) {
            formatter.newLine();
            formatter.append(WKTUtilities.toFormattable(coordinateReferenceSystem));
        }
        formatter.newLine();
        if (!this.isStandardCompliant()) {
            formatter.setInvalidWKT(this, null);
        }
        return bl ? "Compd_CS" : "CompoundCRS";
    }

    private DefaultCompoundCRS() {
        this.components = null;
    }
}

