/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import org.apache.sis.internal.referencing.provider.Affine;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.transform.AbstractMathTransform;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.resources.Errors;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.Matrix;

abstract class AbstractLinearTransform
extends AbstractMathTransform
implements LinearTransform,
Matrix {
    AbstractLinearTransform() {
    }

    @Override
    public boolean isAffine() {
        return Matrices.isAffine(this);
    }

    @Override
    public final Matrix clone() {
        return Matrices.copy(this);
    }

    @Override
    public final Matrix getMatrix() {
        return this;
    }

    @Override
    public int getNumRow() {
        return this.getTargetDimensions() + 1;
    }

    @Override
    public int getNumCol() {
        return this.getSourceDimensions() + 1;
    }

    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        return Affine.getProvider(this.getSourceDimensions(), this.getTargetDimensions(), this.isAffine()).getParameters();
    }

    @Override
    public ParameterValueGroup getParameterValues() {
        return Affine.parameters(this);
    }

    @Override
    public final void setElement(int n, int n2, double d) {
        throw new UnsupportedOperationException(this.isAffine() ? Errors.format((short)119) : Errors.format((short)123, AbstractLinearTransform.class));
    }

    protected abstract boolean equalsSameClass(Object var1);

    @Override
    public final boolean equals(Object object, ComparisonMode comparisonMode) {
        if (object == this) {
            return true;
        }
        if (object != null) {
            if (this.getClass() == object.getClass() && !comparisonMode.isApproximative()) {
                return this.equalsSameClass(object);
            }
            if (comparisonMode != ComparisonMode.STRICT) {
                if (object instanceof LinearTransform) {
                    return Matrices.equals(this, ((LinearTransform)object).getMatrix(), comparisonMode);
                }
                if (object instanceof Matrix) {
                    return Matrices.equals(this, (Matrix)object, comparisonMode);
                }
            }
        }
        return false;
    }

    @Override
    public String toString() {
        return Matrices.toString(this);
    }
}

