/*
 * Decompiled with CFR 0.152.
 */
package com.evolvedbinary.j8fu.fsm;

import com.evolvedbinary.j8fu.Either;
import com.evolvedbinary.j8fu.fsm.EventProcessor;
import com.evolvedbinary.j8fu.fsm.FSM;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class BlockingFSM<State extends Enum<State>, Event extends Enum<Event>>
extends FSM<State, Event> {
    private final boolean optimistic;
    private final ReadWriteLock stateLock = new ReentrantReadWriteLock(true);
    @GuardedBy(value="stateLock")
    private State currentState;

    public BlockingFSM(State initialState, EventProcessor<State, Event> eventProcessor) {
        this(false, initialState, eventProcessor);
    }

    public BlockingFSM(boolean optimistic, State initialState, EventProcessor<State, Event> eventProcessor) {
        super(eventProcessor);
        this.optimistic = optimistic;
        this.currentState = initialState;
    }

    @Override
    public State getCurrentState() {
        this.stateLock.readLock().lock();
        try {
            State State = this.currentState;
            return State;
        }
        finally {
            this.stateLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public State process(Event event) throws IllegalStateException {
        Object optimisticState;
        Either<IllegalStateException, Object> result = null;
        if (this.optimistic) {
            optimisticState = this.getCurrentState();
            result = this.eventProcessor.apply(optimisticState, event);
        } else {
            optimisticState = null;
        }
        this.stateLock.writeLock().lock();
        try {
            if (!this.optimistic || optimisticState != this.currentState) {
                result = this.eventProcessor.apply(this.currentState, event);
            }
            if (result.isLeft()) {
                throw result.left().get();
            }
            Enum newState = (Enum)result.right().get();
            this.currentState = newState;
            Enum enum_ = newState;
            return (State)enum_;
        }
        finally {
            this.stateLock.writeLock().unlock();
        }
    }
}

