/*
 * Decompiled with CFR 0.152.
 */
package com.evolvedbinary.j8fu.fsm;

import com.evolvedbinary.j8fu.Either;
import com.evolvedbinary.j8fu.fsm.EventProcessor;
import com.evolvedbinary.j8fu.fsm.FSM;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
public class StandardFSM<State extends Enum<State>, Event extends Enum<Event>>
extends FSM<State, Event> {
    private State currentState = null;

    public StandardFSM(State initialState, EventProcessor<State, Event> eventProcessor) {
        super(eventProcessor);
        this.currentState = initialState;
    }

    @Override
    public State getCurrentState() {
        return this.currentState;
    }

    @Override
    public State process(Event event) throws IllegalStateException {
        Either<IllegalStateException, State> result = this.eventProcessor.apply(this.currentState, event);
        if (result.isLeft()) {
            throw result.left().get();
        }
        this.currentState = (Enum)result.right().get();
        return this.currentState;
    }
}

