/*
 * Decompiled with CFR 0.152.
 */
package com.evolvedbinary.j8fu.managed;

import java.util.function.BiConsumer;
import java.util.function.Function;

public class ManagedResource<T, AR> {
    private final T subject;
    private final Function<T, AR> acquireFn;
    private final BiConsumer<T, AR> releaseFn;

    private ManagedResource(T subject, Function<T, AR> acquireFn, BiConsumer<T, AR> releaseFn) {
        this.subject = subject;
        this.acquireFn = acquireFn;
        this.releaseFn = releaseFn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <U> U map(Function<AR, U> mapper) {
        Object acquireResult = null;
        try {
            acquireResult = this.acquireFn.apply(this.subject);
            U u = mapper.apply(acquireResult);
            return u;
        }
        finally {
            this.releaseFn.accept(this.subject, acquireResult);
        }
    }

    public static <T, AR> ManagedResource<T, AR> managed(T subject, Function<T, AR> acquireFn, BiConsumer<T, AR> releaseFn) {
        return new ManagedResource<T, AR>(subject, acquireFn, releaseFn);
    }
}

