/*
 * Decompiled with CFR 0.152.
 */
package com.ettrema.httpclient;

import com.ettrema.httpclient.RespUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;

public class LockMethod
extends HttpEntityEnclosingRequestBase {
    public LockMethod(String uri) throws URISyntaxException {
        this.setURI(new URI(uri));
    }

    public String getMethod() {
        return "LOCK";
    }

    public String getLockToken(HttpResponse response) {
        try {
            Document document = this.getResponseAsDocument(response);
            if (document == null) {
                throw new RuntimeException("Got empty response to LOCK request");
            }
            Element root = document.getRootElement();
            List<Element> lockTokenEls = RespUtils.getElements(root, "locktoken");
            Iterator<Element> i$ = lockTokenEls.iterator();
            if (i$.hasNext()) {
                Element el = i$.next();
                String token = RespUtils.asString(el, "href");
                if (token == null) {
                    throw new RuntimeException("No href element in locktoken");
                }
                return token;
            }
            throw new RuntimeException("Didnt find a locktoken/href element in LOCK response");
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public Document getResponseAsDocument(HttpResponse response) throws IOException {
        HttpEntity entity = response.getEntity();
        if (entity == null) {
            return null;
        }
        InputStream in = null;
        try {
            Document document;
            in = entity.getContent();
            Document document2 = document = RespUtils.getJDomDocument(in);
            return document2;
        }
        catch (JDOMException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }
}

