/*
 * Decompiled with CFR 0.152.
 */
package com.ettrema.httpclient;

import com.ettrema.httpclient.PropFindMethod;
import com.ettrema.httpclient.RespUtils;
import com.ettrema.httpclient.Utils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportMethod
extends HttpEntityEnclosingRequestBase {
    private static final Logger log = LoggerFactory.getLogger(PropFindMethod.class);

    public ReportMethod(String uri) throws URISyntaxException {
        this.setURI(new URI(uri));
    }

    public String getMethod() {
        return "REPORT";
    }

    public Document getResponseAsDocument(HttpClient client) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Utils.executeHttpWithStatus(client, (HttpUriRequest)this, out);
        String xml = out.toString();
        try {
            Document document = RespUtils.getJDomDocument(new ByteArrayInputStream(xml.getBytes()));
            return document;
        }
        catch (JDOMException ex) {
            throw new RuntimeException(xml, ex);
        }
    }
}

