/*
 * Decompiled with CFR 0.152.
 */
package com.ettrema.httpclient;

import com.bradmcevoy.http.Range;
import com.bradmcevoy.http.exceptions.BadRequestException;
import com.bradmcevoy.http.exceptions.ConflictException;
import com.bradmcevoy.http.exceptions.NotAuthorizedException;
import com.bradmcevoy.http.exceptions.NotFoundException;
import com.ettrema.common.LogUtils;
import com.ettrema.httpclient.ConnectionListener;
import com.ettrema.httpclient.HttpException;
import com.ettrema.httpclient.HttpResult;
import com.ettrema.httpclient.NotifyingFileInputStream;
import com.ettrema.httpclient.ProgressListener;
import com.ettrema.httpclient.RangedGetMethod;
import com.ettrema.httpclient.StreamReceiver;
import com.ettrema.httpclient.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.InputStreamEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransferService {
    private static final Logger log = LoggerFactory.getLogger(TransferService.class);
    private final HttpClient client;
    private final List<ConnectionListener> connectionListeners;
    private int timeout;

    public TransferService(HttpClient client, List<ConnectionListener> connectionListeners) {
        this.client = client;
        this.connectionListeners = connectionListeners;
    }

    public synchronized void get(String url, StreamReceiver receiver, List<Range> rangeList, ProgressListener listener) throws HttpException, Utils.CancelledException, NotAuthorizedException, BadRequestException, ConflictException, NotFoundException {
        Object m;
        LogUtils.trace((Logger)log, (Object[])new Object[]{"get: ", url});
        this.notifyStartRequest();
        if (rangeList != null) {
            try {
                m = new RangedGetMethod(url, rangeList);
            }
            catch (URISyntaxException ex) {
                throw new RuntimeException(ex);
            }
        } else {
            m = new HttpGet(url);
        }
        InputStream in = null;
        NotifyingFileInputStream nin = null;
        try {
            HttpResponse resp = this.client.execute((HttpUriRequest)m);
            if (resp.getEntity() == null) {
                log.warn("Did not receive a response entity for GET");
                return;
            }
            HttpEntity entity = resp.getEntity();
            in = entity.getContent();
            Utils.processResultCode(resp.getStatusLine().getStatusCode(), url);
            nin = new NotifyingFileInputStream(in, entity.getContentLength(), url, listener);
            receiver.receive(nin);
            Utils.close(in);
            this.notifyFinishRequest();
        }
        catch (Utils.CancelledException ex) {
            m.abort();
            throw ex;
        }
        catch (IOException ex) {
            m.abort();
            throw new RuntimeException(ex);
        }
        finally {
            Utils.close(in);
            this.notifyFinishRequest();
        }
    }

    public HttpResult put(String encodedUrl, InputStream content, Long contentLength, String contentType, ProgressListener listener) {
        HttpResult httpResult;
        LogUtils.trace((Logger)log, (Object[])new Object[]{"put: ", encodedUrl});
        this.notifyStartRequest();
        String s = encodedUrl;
        HttpPut p = new HttpPut(s);
        NotifyingFileInputStream notifyingIn = null;
        try {
            notifyingIn = new NotifyingFileInputStream(content, contentLength, s, listener);
            if (contentLength == null) {
                throw new RuntimeException("Content length for input stream is null, you must provide a length");
            }
            InputStreamEntity requestEntity = new InputStreamEntity((InputStream)notifyingIn, contentLength.longValue());
            p.setEntity((HttpEntity)requestEntity);
            httpResult = Utils.executeHttpWithResult(this.client, (HttpUriRequest)p, null);
        }
        catch (IOException ex) {
            try {
                throw new RuntimeException(ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(notifyingIn);
                this.notifyFinishRequest();
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)notifyingIn);
        this.notifyFinishRequest();
        return httpResult;
    }

    private void notifyStartRequest() {
        for (ConnectionListener l : this.connectionListeners) {
            l.onStartRequest();
        }
    }

    private void notifyFinishRequest() {
        for (ConnectionListener l : this.connectionListeners) {
            l.onFinishRequest();
        }
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }
}

