/*
 * Decompiled with CFR 0.152.
 */
package com.ettrema.httpclient;

import com.bradmcevoy.common.Path;
import com.bradmcevoy.http.exceptions.BadRequestException;
import com.bradmcevoy.http.exceptions.ConflictException;
import com.bradmcevoy.http.exceptions.NotAuthorizedException;
import com.bradmcevoy.http.exceptions.NotFoundException;
import com.ettrema.httpclient.GenericHttpException;
import com.ettrema.httpclient.HttpException;
import com.ettrema.httpclient.HttpResult;
import com.ettrema.httpclient.InternalServerError;
import com.ettrema.httpclient.MethodNotAllowedException;
import com.ettrema.httpclient.ProgressListener;
import com.ettrema.httpclient.RedirectException;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger log = LoggerFactory.getLogger(Utils.class);

    public static String buildEncodedUrl(Path path) {
        String url = "";
        String[] arr = path.getParts();
        for (int i = 0; i < arr.length; ++i) {
            String s = arr[i];
            if (i > 0) {
                url = url + "/";
            }
            url = url + com.bradmcevoy.http.Utils.percentEncode((String)s);
        }
        return url;
    }

    public static int executeHttpWithStatus(HttpClient client, HttpUriRequest m, OutputStream out) throws IOException {
        HttpResult result = Utils.executeHttpWithResult(client, m, out);
        if (log.isTraceEnabled()) {
            for (String key : result.getHeaders().keySet()) {
                log.trace(" header: " + key + " = " + result.getHeaders().get(key));
            }
        }
        return result.getStatusCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpResult executeHttpWithResult(HttpClient client, HttpUriRequest m, OutputStream out) throws IOException {
        Header[] respHeaders;
        HttpResponse resp = client.execute(m);
        HttpEntity entity = resp.getEntity();
        if (entity != null) {
            InputStream in = null;
            try {
                in = entity.getContent();
                if (out != null) {
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                }
            }
            finally {
                IOUtils.closeQuietly((InputStream)in);
            }
        }
        HashMap<String, String> mapOfHeaders = new HashMap<String, String>();
        for (Header h : respHeaders = resp.getAllHeaders()) {
            mapOfHeaders.put(h.getName(), h.getValue());
        }
        HttpResult result = new HttpResult(resp.getStatusLine().getStatusCode(), mapOfHeaders);
        return result;
    }

    public static void close(InputStream in) {
        try {
            if (in == null) {
                return;
            }
            in.close();
        }
        catch (IOException ex) {
            log.warn("Exception closing stream: " + ex.getMessage());
        }
    }

    public static void close(OutputStream out) {
        try {
            if (out == null) {
                return;
            }
            out.close();
        }
        catch (IOException ex) {
            log.warn("Exception closing stream: " + ex.getMessage());
        }
    }

    public static long write(InputStream in, OutputStream out, ProgressListener listener) throws IOException {
        long bytes = 0L;
        byte[] arr = new byte[1024];
        int s = in.read(arr);
        bytes += (long)s;
        try {
            while (s >= 0) {
                if (listener != null && listener.isCancelled()) {
                    throw new CancelledException();
                }
                out.write(arr, 0, s);
                s = in.read(arr);
                bytes += (long)s;
                if (listener == null) continue;
                listener.onProgress(bytes, null, null);
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable e) {
            log.error("exception copying bytes", e);
            throw new RuntimeException(e);
        }
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long writeBuffered(InputStream in, OutputStream out, ProgressListener listener) throws IOException {
        long l;
        BufferedOutputStream bout = null;
        try {
            bout = new BufferedOutputStream(out);
            long bytes = Utils.write(in, out, listener);
            bout.flush();
            out.flush();
            l = bytes;
        }
        catch (Throwable throwable) {
            Utils.close(bout);
            Utils.close(out);
            throw throwable;
        }
        Utils.close(bout);
        Utils.close(out);
        return l;
    }

    public static void processResultCode(int result, String href) throws HttpException, NotAuthorizedException, ConflictException, BadRequestException, NotFoundException {
        block17: {
            block16: {
                if (result >= 200 && result < 300) {
                    return;
                }
                if (result < 300 || result >= 400) break block16;
                switch (result) {
                    case 301: {
                        throw new RedirectException(result, href);
                    }
                    case 302: {
                        throw new RedirectException(result, href);
                    }
                    case 304: {
                        break block17;
                    }
                    default: {
                        throw new RedirectException(result, href);
                    }
                }
            }
            if (result >= 400 && result < 500) {
                switch (result) {
                    case 400: {
                        throw new BadRequestException(href);
                    }
                    case 401: {
                        throw new NotAuthorizedException(href, null);
                    }
                    case 403: {
                        throw new NotAuthorizedException(href, null);
                    }
                    case 404: {
                        throw new NotFoundException(href);
                    }
                    case 405: {
                        throw new MethodNotAllowedException(result, href);
                    }
                    case 409: {
                        throw new ConflictException(href);
                    }
                }
                throw new GenericHttpException(result, href);
            }
            if (result >= 500 && result < 600) {
                throw new InternalServerError(href, result);
            }
            throw new GenericHttpException(result, href);
        }
    }

    public static String format(Map<String, String> parameters, String encoding) {
        StringBuilder result = new StringBuilder();
        for (Map.Entry<String, String> p : parameters.entrySet()) {
            String encodedValue;
            String encodedName = Utils.encode(p.getKey(), encoding);
            String value = p.getValue();
            String string = encodedValue = value != null ? Utils.encode(value, encoding) : "";
            if (result.length() > 0) {
                result.append("&");
            }
            result.append(encodedName);
            result.append("=");
            result.append(encodedValue);
        }
        return result.toString();
    }

    private static String encode(String content, String encoding) {
        try {
            return URLEncoder.encode(content, encoding != null ? encoding : "ISO-8859-1");
        }
        catch (UnsupportedEncodingException problem) {
            throw new IllegalArgumentException(problem);
        }
    }

    public static class CancelledException
    extends IOException {
    }
}

