/*
 * Decompiled with CFR 0.152.
 */
package com.ettrema.httpclient.zsyncclient;

import com.bradmcevoy.http.Range;
import com.ettrema.httpclient.File;
import com.ettrema.httpclient.HttpException;
import com.ettrema.httpclient.ProgressListener;
import com.ettrema.httpclient.Utils;
import com.ettrema.httpclient.zsyncclient.RangeLoader;
import java.io.ByteArrayOutputStream;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRangeLoader
implements RangeLoader {
    private static final Logger log = LoggerFactory.getLogger(HttpRangeLoader.class);
    private final File file;
    private final ProgressListener listener;
    private long numBytes;

    public HttpRangeLoader(File file, ProgressListener listener) {
        this.file = file;
        this.listener = listener;
    }

    @Override
    public byte[] get(List<Range> rangeList) {
        log.info("get: rangelist: " + rangeList.size());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.file.download(out, this.listener, rangeList);
        }
        catch (HttpException ex) {
        }
        catch (Utils.CancelledException ex) {
            throw new RuntimeException("Cancelled, which is odd because no progress listener was provided");
        }
        byte[] bytes = out.toByteArray();
        int expectedLength = HttpRangeLoader.calcExpectedLength(rangeList);
        this.numBytes += (long)bytes.length;
        return bytes;
    }

    public static int calcExpectedLength(List<Range> rangeList) {
        int l = 0;
        for (Range r : rangeList) {
            l = (int)((long)l + (r.getFinish() - r.getStart()));
        }
        return l;
    }

    public long getBytesDownloaded() {
        return this.numBytes;
    }
}

