/*
 * Decompiled with CFR 0.152.
 */
package org.expath.exist;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.dom.memtree.MemTreeBuilder;
import org.exist.dom.persistent.BinaryDocument;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.security.PermissionDeniedException;
import org.exist.storage.lock.Lock;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.AnyURIValue;
import org.exist.xquery.value.Base64BinaryValueType;
import org.exist.xquery.value.BinaryValue;
import org.exist.xquery.value.BinaryValueFromInputStream;
import org.exist.xquery.value.BinaryValueManager;
import org.exist.xquery.value.BinaryValueType;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ZipFileFunctions
extends BasicFunction {
    private static final Logger logger = LogManager.getLogger(ZipFileFunctions.class);
    private static final FunctionParameterSequenceType HREF_PARAM = new FunctionParameterSequenceType("href", 25, 2, "The URI for locating the Zip file");
    private static final FunctionParameterSequenceType ENTRY_PARAM = new FunctionParameterSequenceType("entry", 1, 2, "A zip:entry element describing the contents of the file");
    private static final String FILE_ENTRIES = "entries";
    private static final String ZIP_FILE = "zip-file";
    private static final String UPDATE_ENTRIES = "update";
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("entries", "http://expath.org/ns/zip", "zip"), "Returns a zip:file element that describes the hierarchical structure of the ZIP file identified by $href in terms of ZIP entries", new SequenceType[]{HREF_PARAM}, (SequenceType)new FunctionReturnSequenceType(-1, 2, "The document node containing a zip:entry")), new FunctionSignature(new QName("update", "http://expath.org/ns/zip", "zip"), "Returns a copy of the zip file at $href, after replacing or adding each binary using the matching path/filename in $paths.", new SequenceType[]{new FunctionParameterSequenceType("href", 25, 2, "The URI for locating the Zip file"), new FunctionParameterSequenceType("paths", 22, 6, "a sequence of file paths"), new FunctionParameterSequenceType("binaries", 26, 6, "a sequence of binaries matching the paths")}, (SequenceType)new FunctionReturnSequenceType(26, 3, "The new zipped data or the empty sequence if the numbers of $paths and $binaries are different"))};

    public ZipFileFunctions(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        Sequence result = Sequence.EMPTY_SEQUENCE;
        if (this.isCalledAs(FILE_ENTRIES)) {
            XmldbURI uri = ((AnyURIValue)args[0].itemAt(0)).toXmldbURI();
            result = this.extractEntries(uri);
        } else if (this.isCalledAs(ZIP_FILE)) {
            Element zipEntry = (Element)args[0].itemAt(0);
            result = this.createZip(zipEntry);
        } else if (this.isCalledAs(UPDATE_ENTRIES)) {
            XmldbURI uri = ((AnyURIValue)args[0].itemAt(0)).toXmldbURI();
            String[] paths = this.getPaths(args[1]);
            BinaryValue[] newData = this.getBinaryData(args[2]);
            result = this.updateZip(uri, paths, newData);
        }
        return result;
    }

    private Sequence updateZip(XmldbURI uri, String[] paths, BinaryValue[] binaries) throws XPathException {
        if (paths.length != binaries.length) {
            throw new XPathException("Different number of paths (" + paths.length + ") and binaries (" + binaries.length + ")");
        }
        ZipFileFromDb zipFileSource = new ZipFileFromDb(uri);
        ZipInputStream zis = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        HashMap<String, BinaryValue> binariesTable = new HashMap<String, BinaryValue>(paths.length);
        for (int i = 0; i < paths.length; ++i) {
            binariesTable.put(paths[i], binaries[i]);
        }
        try {
            ZipEntry ze;
            zis = zipFileSource.getStream();
            ZipOutputStream zos = new ZipOutputStream((OutputStream)baos);
            byte[] buffer = new byte[16384];
            while ((ze = zis.getNextEntry()) != null) {
                int bytes_read;
                ZipEntry nze;
                String zen = ze.getName();
                if (binariesTable.containsKey(zen)) {
                    nze = new ZipEntry(zen);
                    zos.putNextEntry(nze);
                    ((BinaryValue)binariesTable.get(zen)).streamBinaryTo((OutputStream)zos);
                    binariesTable.remove(zen);
                    continue;
                }
                if (ze.isDirectory()) {
                    ZipEntry dirEntry = new ZipEntry(ze.getName() + System.getProperty("file.separator") + ".");
                    zos.putNextEntry(dirEntry);
                    continue;
                }
                nze = new ZipEntry(zen);
                zos.putNextEntry(nze);
                while ((bytes_read = zis.read(buffer)) != -1) {
                    zos.write(buffer, 0, bytes_read);
                }
            }
            for (Map.Entry entry : binariesTable.entrySet()) {
                ZipEntry nze = new ZipEntry((String)entry.getKey());
                zos.putNextEntry(nze);
                ((BinaryValue)entry.getValue()).streamBinaryTo((OutputStream)zos);
            }
            zos.close();
            zis.close();
            return BinaryValueFromInputStream.getInstance((BinaryValueManager)this.context, (BinaryValueType)new Base64BinaryValueType(), (InputStream)new ByteArrayInputStream(baos.toByteArray()));
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new XPathException("IO Exception in zip:update");
        }
        catch (PermissionDeniedException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new XPathException("Permission denied to read the source zip");
        }
    }

    private Sequence extractEntries(XmldbURI uri) throws XPathException {
        ZipFileFromDb zipFileSource = new ZipFileFromDb(uri);
        ZipInputStream zis = null;
        NodeValue xmlResponse = null;
        MemTreeBuilder builder = this.context.getDocumentBuilder();
        builder.startDocument();
        builder.startElement(new QName("file", "http://expath.org/ns/zip", "zip"), null);
        builder.addAttribute(new QName("href", null, null), uri.toString());
        try {
            ZipEntry zipEntry;
            zis = zipFileSource.getStream();
            while ((zipEntry = zis.getNextEntry()) != null) {
                if (zipEntry.isDirectory()) {
                    builder.startElement(new QName("dir", "http://expath.org/ns/zip", "zip"), null);
                    builder.addAttribute(new QName("name", null, null), zipEntry.toString());
                    builder.endElement();
                    continue;
                }
                logger.debug("file: " + zipEntry.getName());
                builder.startElement(new QName("entry", "http://expath.org/ns/zip", "zip"), null);
                builder.addAttribute(new QName("name", null, null), zipEntry.toString());
                builder.endElement();
            }
        }
        catch (PermissionDeniedException pde) {
            logger.error(pde.getMessage(), (Throwable)pde);
            throw new XPathException("Permission denied to read the source zip");
        }
        catch (IOException ioe) {
            logger.error(ioe.getMessage(), (Throwable)ioe);
            throw new XPathException("IO exception while reading the source zip");
        }
        builder.endElement();
        xmlResponse = (NodeValue)builder.getDocument().getDocumentElement();
        return xmlResponse;
    }

    private Sequence createZip(Element zipFile) {
        logger.debug("processing zipFile: " + zipFile.getAttribute("href"));
        for (Node child = zipFile.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1) continue;
            Element e = (Element)child;
            String s = e.getLocalName();
            if (s.equals("entry")) {
                logger.debug("zip:entry name: " + e.getAttribute("name") + " src: " + e.getAttribute("src"));
                continue;
            }
            if (!s.equals("dir")) continue;
            logger.debug("zip:entry contains dir: " + e.getAttribute("name") + " src: " + e.getAttribute("src"));
        }
        return Sequence.EMPTY_SEQUENCE;
    }

    private String[] getPaths(Sequence seq) {
        String[] paths = new String[seq.getItemCount()];
        for (int i = 0; i < seq.getItemCount(); ++i) {
            paths[i] = seq.itemAt(i).toString();
        }
        return paths;
    }

    private BinaryValue[] getBinaryData(Sequence seq) {
        BinaryValue[] binaries = new BinaryValue[seq.getItemCount()];
        for (int i = 0; i < seq.getItemCount(); ++i) {
            binaries[i] = (BinaryValue)seq.itemAt(i);
        }
        return binaries;
    }

    private class ZipFileFromDb
    implements ZipFileSource {
        private BinaryDocument binaryDoc = null;
        private final XmldbURI uri;

        public ZipFileFromDb(XmldbURI uri) {
            this.uri = uri;
        }

        @Override
        public ZipInputStream getStream() throws IOException, PermissionDeniedException {
            if (this.binaryDoc == null) {
                this.binaryDoc = this.getBinaryDoc();
            }
            return new ZipInputStream(ZipFileFunctions.this.context.getBroker().getBinaryResource(this.binaryDoc));
        }

        @Override
        public void close() {
            if (this.binaryDoc != null) {
                this.binaryDoc.getUpdateLock().release(Lock.LockMode.READ_LOCK);
            }
        }

        private BinaryDocument getBinaryDoc() throws PermissionDeniedException {
            DocumentImpl doc = ZipFileFunctions.this.context.getBroker().getXMLResource(this.uri, Lock.LockMode.READ_LOCK);
            if (doc == null) {
                return null;
            }
            if (doc.getResourceType() != 1) {
                doc.getUpdateLock().release(Lock.LockMode.READ_LOCK);
                return null;
            }
            return (BinaryDocument)doc;
        }
    }

    public static interface ZipFileSource {
        public ZipInputStream getStream() throws IOException, PermissionDeniedException;

        public void close();
    }
}

