/*
 * Decompiled with CFR 0.152.
 */
package org.expath.tools.model.exist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.xml.namespace.QName;
import org.exist.dom.QName;
import org.exist.interpreter.Context;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.ValueSequence;
import org.expath.tools.ToolsException;
import org.expath.tools.model.Attribute;
import org.expath.tools.model.Element;
import org.expath.tools.model.Sequence;
import org.expath.tools.model.exist.EXistAttribute;
import org.expath.tools.model.exist.EXistSequence;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EXistElement
implements Element {
    private final NodeValue element;
    private final XQueryContext context;

    public EXistElement(NodeValue element, XQueryContext context) {
        this.element = element;
        this.context = context;
    }

    public Iterable<Attribute> attributes() {
        return new Iterable<Attribute>(){

            @Override
            public Iterator<Attribute> iterator() {
                return new Iterator<Attribute>(){
                    private final NamedNodeMap attrs;
                    private final int length;
                    private int position;
                    {
                        this.attrs = EXistElement.this.element.getNode().getAttributes();
                        this.length = this.attrs.getLength();
                        this.position = 0;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.position < this.length;
                    }

                    @Override
                    public Attribute next() {
                        if (this.position >= this.length) {
                            throw new NoSuchElementException();
                        }
                        return new EXistAttribute((Attr)this.attrs.item(this.position++));
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("Not supported yet.");
                    }
                };
            }
        };
    }

    public Iterable<Element> children() {
        Node node = this.element.getNode();
        return new IterableElement(node);
    }

    public String getAttribute(String local_name) {
        String attrValue = null;
        NamedNodeMap attrs = this.element.getNode().getAttributes();
        Node attr = attrs.getNamedItem(local_name);
        if (attr != null) {
            attrValue = ((Attr)attr).getValue();
        }
        return attrValue;
    }

    public Sequence getContent() {
        ValueSequence valueSequence = new ValueSequence();
        NodeList children = this.element.getNode().getChildNodes();
        try {
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                valueSequence.add((Item)((NodeValue)child));
            }
            return new EXistSequence((org.exist.xquery.value.Sequence)valueSequence, this.context);
        }
        catch (XPathException xpe) {
            throw new RuntimeException(xpe.getMessage(), xpe);
        }
    }

    public String getDisplayName() {
        return this.element.getNode().getNodeName();
    }

    public String getLocalName() {
        return this.element.getNode().getLocalName();
    }

    public String getNamespaceUri() {
        return this.element.getNode().getNamespaceURI();
    }

    public boolean hasNoNsChild() {
        NodeList children = this.element.getNode().getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if ((child.getNamespaceURI() != null || child.getPrefix() != null) && !child.getNamespaceURI().equals("")) continue;
            return true;
        }
        return false;
    }

    public Iterable<Element> children(String ns) {
        Node node = this.element.getNode();
        return new IterableElement(node, ns);
    }

    public void noOtherNCNameAttribute(String[] names, String[] forbidden_ns) throws ToolsException {
        if (forbidden_ns == null) {
            forbidden_ns = new String[]{};
        }
        Object[] sorted_names = this.sortCopy(names);
        Object[] sorted_ns = this.sortCopy(forbidden_ns);
        NamedNodeMap attributes = this.element.getNode().getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attr = attributes.item(i);
            String attr_name = attr.getLocalName();
            String ns = attr.getNamespaceURI();
            if (ns != null && Arrays.binarySearch(sorted_ns, ns) >= 0) {
                if (!ns.equals("http://expath.org/ns/http-client")) continue;
                throw new ToolsException("@" + attr_name + " in namespace " + ns + " not allowed on " + this.getDisplayName());
            }
            if (ns != null && !ns.isEmpty() || Arrays.binarySearch(sorted_names, attr.getLocalName()) >= 0) continue;
            throw new ToolsException("@" + attr_name + " not allowed on " + this.getDisplayName());
        }
    }

    private String[] sortCopy(String[] array) {
        Object[] sorted = new String[array.length];
        System.arraycopy(array, 0, sorted, 0, sorted.length);
        Arrays.sort(sorted);
        return sorted;
    }

    public QName parseQName(String value) throws ToolsException {
        try {
            org.exist.dom.QName qn = org.exist.dom.QName.parse((Context)this.context, (String)value, (String)this.element.getQName().getNamespaceURI());
            return qn.toJavaQName();
        }
        catch (QName.IllegalQNameException ex) {
            throw new ToolsException("Error parsing the literal QName: " + value, (Throwable)ex);
        }
    }

    public class ElementIterator
    implements Iterator<Element> {
        private final Node parent;
        private final String inNamespaceURI;
        private List<org.w3c.dom.Element> elements = null;
        private int position = 0;

        public ElementIterator(Node parent, String inNamespaceURI) {
            this.parent = parent;
            this.inNamespaceURI = inNamespaceURI;
        }

        @Override
        public boolean hasNext() {
            return this.position < this.getLength();
        }

        @Override
        public Element next() {
            if (this.position >= this.getLength()) {
                throw new NoSuchElementException();
            }
            return new EXistElement((NodeValue)this.getElements().get(this.position++), EXistElement.this.context);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        private int getLength() {
            return this.getElements().size();
        }

        private List<org.w3c.dom.Element> getElements() {
            if (this.elements == null) {
                this.elements = new ArrayList<org.w3c.dom.Element>();
                NodeList children = this.parent.getChildNodes();
                for (int i = 0; i < children.getLength(); ++i) {
                    Node child = children.item(i);
                    if (child.getNodeType() != 1) continue;
                    if (this.inNamespaceURI != null) {
                        String ns = child.getNamespaceURI();
                        if (ns == null || !this.inNamespaceURI.equals(ns)) continue;
                        this.elements.add((org.w3c.dom.Element)child);
                        continue;
                    }
                    this.elements.add((org.w3c.dom.Element)child);
                }
            }
            return this.elements;
        }
    }

    public class IterableElement
    implements Iterable<Element> {
        private final Node node;
        private String inNamespaceURI = null;

        public IterableElement(Node node) {
            this.node = node;
        }

        public IterableElement(Node node, String inNamespaceURI) {
            this.node = node;
            this.inNamespaceURI = inNamespaceURI;
        }

        @Override
        public Iterator<Element> iterator() {
            return new ElementIterator(this.node, this.inNamespaceURI);
        }
    }
}

