/*
 * Decompiled with CFR 0.152.
 */
package org.exist.indexing.sort;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.backup.RawDataBackup;
import org.exist.indexing.AbstractIndex;
import org.exist.indexing.IndexWorker;
import org.exist.indexing.RawBackupSupport;
import org.exist.indexing.sort.SortIndexWorker;
import org.exist.storage.DBBroker;
import org.exist.storage.btree.DBException;
import org.exist.storage.index.BTreeStore;
import org.exist.storage.lock.Lock;
import org.exist.util.DatabaseConfigurationException;
import org.exist.util.FileUtils;
import org.exist.util.LockException;

public class SortIndex
extends AbstractIndex
implements RawBackupSupport {
    public static final String ID = SortIndex.class.getName();
    public static final String FILE_NAME = "sort.dbx";
    public static final byte SORT_INDEX_ID = 16;
    protected static final Logger LOG = LogManager.getLogger(SortIndex.class);
    protected BTreeStore btree;

    public void open() throws DatabaseConfigurationException {
        Path file = this.getDataDir().resolve(FILE_NAME);
        LOG.debug("Creating '" + FileUtils.fileName((Path)file) + "'...");
        try {
            this.btree = new BTreeStore(this.pool, 16, false, file, this.pool.getCacheManager());
        }
        catch (DBException e) {
            LOG.error("Failed to initialize structural index: " + e.getMessage(), (Throwable)e);
            throw new DatabaseConfigurationException(e.getMessage(), (Throwable)e);
        }
    }

    public void close() throws DBException {
        this.btree.close();
        this.btree = null;
    }

    public void sync() throws DBException {
        if (this.btree == null) {
            return;
        }
        Lock lock = this.btree.getLock();
        try {
            lock.acquire(Lock.LockMode.WRITE_LOCK);
            this.btree.flush();
        }
        catch (LockException e) {
            LOG.warn("Failed to acquire lock for '" + FileUtils.fileName((Path)this.btree.getFile()) + "'", (Throwable)e);
        }
        catch (DBException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        finally {
            lock.release(Lock.LockMode.WRITE_LOCK);
        }
    }

    public void remove() throws DBException {
        this.btree.closeAndRemove();
    }

    public IndexWorker getWorker(DBBroker broker) {
        return new SortIndexWorker(this);
    }

    public boolean checkIndex(DBBroker broker) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void backupToArchive(RawDataBackup backup) throws IOException {
        try (OutputStream os = backup.newEntry(FileUtils.fileName((Path)this.btree.getFile()));){
            this.btree.backupToStream(os);
        }
        finally {
            backup.closeEntry();
        }
    }
}

