/*
 * Decompiled with CFR 0.152.
 */
package org.exist.indexing.sort;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.exist.EXistException;
import org.exist.collections.Collection;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.dom.persistent.DocumentSet;
import org.exist.dom.persistent.IStoredNode;
import org.exist.dom.persistent.NodeProxy;
import org.exist.dom.persistent.NodeSet;
import org.exist.indexing.IndexController;
import org.exist.indexing.IndexWorker;
import org.exist.indexing.MatchListener;
import org.exist.indexing.StreamListener;
import org.exist.indexing.sort.SortIndex;
import org.exist.indexing.sort.SortItem;
import org.exist.storage.DBBroker;
import org.exist.storage.NodePath;
import org.exist.storage.btree.BTreeCallback;
import org.exist.storage.btree.BTreeException;
import org.exist.storage.btree.IndexQuery;
import org.exist.storage.btree.Value;
import org.exist.storage.lock.Lock;
import org.exist.util.ByteConversion;
import org.exist.util.DatabaseConfigurationException;
import org.exist.util.LockException;
import org.exist.util.Occurrences;
import org.exist.util.UTF8;
import org.exist.xquery.QueryRewriter;
import org.exist.xquery.TerminatedException;
import org.exist.xquery.XQueryContext;
import org.w3c.dom.NodeList;

public class SortIndexWorker
implements IndexWorker {
    private StreamListener.ReindexMode mode = StreamListener.ReindexMode.STORE;
    private DocumentImpl document = null;
    private SortIndex index;

    public SortIndexWorker(SortIndex index) {
        this.index = index;
    }

    public void setDocument(DocumentImpl doc, StreamListener.ReindexMode mode) {
        this.document = doc;
        this.mode = mode;
    }

    public String getIndexId() {
        return SortIndex.ID;
    }

    public String getIndexName() {
        return this.index.getIndexName();
    }

    public QueryRewriter getQueryRewriter(XQueryContext context) {
        return null;
    }

    public void flush() {
        switch (this.mode) {
            case REMOVE_ALL_NODES: {
                this.remove(this.document);
            }
        }
    }

    public void createIndex(String name, List<SortItem> items) throws EXistException, LockException {
        short id = this.getOrRegisterId(name);
        Lock lock = this.index.btree.getLock();
        try {
            lock.acquire(Lock.LockMode.WRITE_LOCK);
            long idx = 0L;
            for (SortItem item : items) {
                byte[] key = this.computeKey(id, item.getNode());
                this.index.btree.addValue(new Value(key), idx++);
            }
        }
        catch (IOException | BTreeException | LockException e) {
            throw new EXistException("Exception caught while creating sort index: " + e.getMessage(), e);
        }
        finally {
            lock.release(Lock.LockMode.WRITE_LOCK);
        }
    }

    public boolean hasIndex(String name) throws EXistException, LockException {
        return this.getId(name) > 0;
    }

    public long getIndex(String name, NodeProxy proxy) throws EXistException, LockException {
        short id = this.getId(name);
        Lock lock = this.index.btree.getLock();
        try {
            lock.acquire(Lock.LockMode.READ_LOCK);
            byte[] key = this.computeKey(id, proxy);
            long l = this.index.btree.findValue(new Value(key));
            return l;
        }
        catch (IOException | BTreeException | LockException e) {
            throw new EXistException("Exception caught while reading sort index: " + e.getMessage(), e);
        }
        finally {
            lock.release(Lock.LockMode.READ_LOCK);
        }
    }

    public void remove(String name) throws EXistException, LockException {
        short id = this.getId(name);
        Lock lock = this.index.btree.getLock();
        try {
            lock.acquire(Lock.LockMode.READ_LOCK);
            byte[] fromKey = this.computeKey(id);
            byte[] toKey = this.computeKey((short)(id + 1));
            IndexQuery query = new IndexQuery(10, new Value(fromKey), new Value(toKey));
            this.index.btree.remove(query, null);
            this.removeId(name);
        }
        catch (IOException | BTreeException | TerminatedException e) {
            throw new EXistException("Exception caught while deleting sort index: " + e.getMessage(), e);
        }
        finally {
            lock.release(Lock.LockMode.READ_LOCK);
        }
    }

    public void remove(String name, DocumentImpl doc) throws EXistException, LockException {
        short id = this.getId(name);
        this.remove(doc, id);
    }

    private void remove(DocumentImpl doc, short id) throws LockException, EXistException {
        Lock lock = this.index.btree.getLock();
        try {
            lock.acquire(Lock.LockMode.READ_LOCK);
            byte[] fromKey = this.computeKey(id, doc.getDocId());
            byte[] toKey = this.computeKey(id, doc.getDocId() + 1);
            IndexQuery query = new IndexQuery(10, new Value(fromKey), new Value(toKey));
            this.index.btree.remove(query, null);
        }
        catch (IOException | BTreeException | TerminatedException e) {
            throw new EXistException("Exception caught while deleting sort index: " + e.getMessage(), e);
        }
        finally {
            lock.release(Lock.LockMode.READ_LOCK);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(DocumentImpl doc) {
        if (this.index.btree == null) {
            return;
        }
        byte[] fromKey = new byte[]{1};
        byte[] endKey = new byte[]{2};
        Lock lock = this.index.btree.getLock();
        try {
            lock.acquire(Lock.LockMode.READ_LOCK);
            IndexQuery query = new IndexQuery(10, new Value(fromKey), new Value(endKey));
            FindIdCallback callback = new FindIdCallback(true);
            this.index.btree.query(query, (BTreeCallback)callback);
            for (long id : callback.allIds) {
                this.remove(doc, (short)id);
            }
        }
        catch (IOException | EXistException | BTreeException | LockException | TerminatedException e) {
            SortIndex.LOG.debug("Exception caught while reading sort index: " + e.getMessage(), e);
        }
        finally {
            lock.release(Lock.LockMode.READ_LOCK);
        }
    }

    private short getOrRegisterId(String name) throws EXistException, LockException {
        short id = this.getId(name);
        if (id < 0) {
            byte[] fromKey = new byte[]{1};
            byte[] endKey = new byte[]{2};
            IndexQuery query = new IndexQuery(10, new Value(fromKey), new Value(endKey));
            Lock lock = this.index.btree.getLock();
            try {
                lock.acquire(Lock.LockMode.READ_LOCK);
                FindIdCallback callback = new FindIdCallback(false);
                this.index.btree.query(query, (BTreeCallback)callback);
                id = (short)(callback.max + 1L);
                this.registerId(id, name);
            }
            catch (IOException | BTreeException | TerminatedException e) {
                throw new EXistException("Exception caught while reading sort index: " + e.getMessage(), e);
            }
            finally {
                lock.release(Lock.LockMode.READ_LOCK);
            }
        }
        return id;
    }

    private void registerId(short id, String name) throws EXistException {
        byte[] key = new byte[1 + UTF8.encoded((String)name)];
        key[0] = 1;
        UTF8.encode((String)name, (byte[])key, (int)1);
        Lock lock = this.index.btree.getLock();
        try {
            lock.acquire(Lock.LockMode.READ_LOCK);
            this.index.btree.addValue(new Value(key), (long)id);
        }
        catch (IOException | BTreeException | LockException e) {
            throw new EXistException("Exception caught while reading sort index: " + e.getMessage(), e);
        }
        finally {
            lock.release(Lock.LockMode.READ_LOCK);
        }
    }

    private void removeId(String name) throws EXistException {
        byte[] key = new byte[1 + UTF8.encoded((String)name)];
        key[0] = 1;
        UTF8.encode((String)name, (byte[])key, (int)1);
        Lock lock = this.index.btree.getLock();
        try {
            lock.acquire(Lock.LockMode.READ_LOCK);
            this.index.btree.removeValue(new Value(key));
        }
        catch (IOException | BTreeException | LockException e) {
            throw new EXistException("Exception caught while reading sort index: " + e.getMessage(), e);
        }
        finally {
            lock.release(Lock.LockMode.READ_LOCK);
        }
    }

    private short getId(String name) throws EXistException, LockException {
        byte[] key = new byte[1 + UTF8.encoded((String)name)];
        key[0] = 1;
        UTF8.encode((String)name, (byte[])key, (int)1);
        Lock lock = this.index.btree.getLock();
        try {
            lock.acquire(Lock.LockMode.READ_LOCK);
            short s = (short)this.index.btree.findValue(new Value(key));
            return s;
        }
        catch (IOException | BTreeException e) {
            throw new EXistException("Exception caught while reading sort index: " + e.getMessage(), e);
        }
        finally {
            lock.release(Lock.LockMode.READ_LOCK);
        }
    }

    private byte[] computeKey(short id, NodeProxy proxy) {
        byte[] data = new byte[7 + proxy.getNodeId().size()];
        data[0] = 0;
        ByteConversion.shortToByteH((short)id, (byte[])data, (int)1);
        ByteConversion.intToByteH((int)proxy.getOwnerDocument().getDocId(), (byte[])data, (int)3);
        proxy.getNodeId().serialize(data, 7);
        return data;
    }

    private byte[] computeKey(short id, int docId) {
        byte[] data = new byte[7];
        data[0] = 0;
        ByteConversion.shortToByteH((short)id, (byte[])data, (int)1);
        ByteConversion.intToByteH((int)docId, (byte[])data, (int)3);
        return data;
    }

    private byte[] computeKey(short id) {
        byte[] data = new byte[3];
        data[0] = 0;
        ByteConversion.shortToByteH((short)id, (byte[])data, (int)1);
        return data;
    }

    public Object configure(IndexController controller, NodeList configNodes, Map<String, String> namespaces) throws DatabaseConfigurationException {
        return null;
    }

    public DocumentImpl getDocument() {
        return this.document;
    }

    public void setDocument(DocumentImpl doc) {
        this.document = doc;
    }

    public StreamListener.ReindexMode getMode() {
        return this.mode;
    }

    public void setMode(StreamListener.ReindexMode mode) {
        this.mode = mode;
    }

    public IStoredNode getReindexRoot(IStoredNode node, NodePath path, boolean insert, boolean includeSelf) {
        return insert ? null : node;
    }

    public StreamListener getListener() {
        return null;
    }

    public MatchListener getMatchListener(DBBroker broker, NodeProxy proxy) {
        return null;
    }

    public void removeCollection(Collection collection, DBBroker broker, boolean reindex) {
    }

    public boolean checkIndex(DBBroker broker) {
        return false;
    }

    public Occurrences[] scanIndex(XQueryContext context, DocumentSet docs, NodeSet contextSet, Map hints) {
        return new Occurrences[0];
    }

    private static final class FindIdCallback
    implements BTreeCallback {
        long max = 0L;
        List<Long> allIds = null;

        private FindIdCallback(boolean findIds) {
            if (findIds) {
                this.allIds = new ArrayList<Long>(10);
            }
        }

        public boolean indexInfo(Value value, long pointer) throws TerminatedException {
            this.max = Math.max(this.max, pointer);
            if (this.allIds != null) {
                this.allIds.add(pointer);
            }
            return true;
        }
    }
}

