/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.sort;

import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.EXistException;
import org.exist.dom.QName;
import org.exist.dom.persistent.NodeProxy;
import org.exist.indexing.sort.SortIndex;
import org.exist.indexing.sort.SortIndexWorker;
import org.exist.indexing.sort.SortItem;
import org.exist.util.FastQSort;
import org.exist.util.LockException;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReference;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.NumericValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.Type;
import org.w3c.dom.Element;

public class CreateOrderIndex
extends BasicFunction {
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("create-index", "http://exist-db.org/xquery/sort", "sort"), "Create a sort index to be used within an 'order by' expression.", new SequenceType[]{new FunctionParameterSequenceType("id", 22, 2, "The id by which the index will be known and distinguished from other indexes on the same nodes."), new FunctionParameterSequenceType("nodes", -1, 7, "The node set to be indexed."), new FunctionParameterSequenceType("values", 20, 7, "The values to be indexed. There should be one value for each node in $nodes. $values thus needs to contain as many items as $nodes. If not, a dynamic error is triggered."), new FunctionParameterSequenceType("options", 1, 3, "<options order='ascending|descending' empty='least|greatest'/>")}, (SequenceType)new FunctionReturnSequenceType(11, 7, "")), new FunctionSignature(new QName("create-index-callback", "http://exist-db.org/xquery/sort", "sort"), "Create a sort index to be used within an 'order by' expression.", new SequenceType[]{new FunctionParameterSequenceType("id", 22, 2, "The id by which the index will be known and distinguished from other indexes on the same nodes."), new FunctionParameterSequenceType("nodes", -1, 7, "The node set to be indexed."), new FunctionParameterSequenceType("callback", 101, 2, "A callback function which will be called for every node in the $nodes input set. The function receives the current node as single argument and should return an atomic value by which the node will be sorted."), new FunctionParameterSequenceType("options", 1, 3, "<options order='ascending|descending' empty='least|greatest'/>")}, (SequenceType)new FunctionReturnSequenceType(11, 7, ""))};
    protected static final Logger LOG = LogManager.getLogger(CreateOrderIndex.class);
    private boolean descending = false;
    private boolean emptyLeast = false;

    public CreateOrderIndex(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (args[1].isEmpty()) {
            return Sequence.EMPTY_SEQUENCE;
        }
        String id = args[0].getStringValue();
        FunctionReference call = null;
        if (this.isCalledAs("create-index-callback")) {
            call = (FunctionReference)args[2].itemAt(0);
        } else if (args[2].getItemCount() != args[1].getItemCount()) {
            throw new XPathException((Expression)this, "$nodes and $values sequences need to have the same length.");
        }
        if (args[3].getItemCount() > 0) {
            NodeValue optionValue = (NodeValue)args[3].itemAt(0);
            Element options = (Element)optionValue.getNode();
            String option = options.getAttribute("order");
            if (option != null) {
                this.descending = option.equalsIgnoreCase("descending");
            }
            if ((option = options.getAttribute("empty")) != null) {
                this.emptyLeast = option.equalsIgnoreCase("least");
            }
        }
        ArrayList<SortItem> items = new ArrayList<SortItem>(args[1].getItemCount());
        Sequence[] params = new Sequence[1];
        SequenceIterator valuesIter = null;
        if (call == null) {
            valuesIter = args[2].iterate();
        }
        int c = 0;
        int len = args[1].getItemCount();
        int logChunk = 1 + len / 20;
        SequenceIterator nodesIter = args[1].iterate();
        while (nodesIter.hasNext()) {
            NodeValue nv = (NodeValue)nodesIter.nextItem();
            if (nv.getImplementationType() == 0) {
                throw new XPathException((Expression)this, "Cannot create order-index on an in-memory node");
            }
            NodeProxy node = (NodeProxy)nv;
            SortItemImpl si = new SortItemImpl(node);
            if (LOG.isDebugEnabled() && ++c % logChunk == 0) {
                LOG.debug("Storing item " + c + " out of " + len + " to sort index.");
            }
            if (call != null) {
                params[0] = node;
                Sequence r = call.evalFunction(contextSequence, null, params);
                if (!r.isEmpty()) {
                    AtomicValue v = r.itemAt(0).atomize();
                    if (v.getType() == 21) {
                        v = v.convertTo(22);
                    }
                    si.setValue(v);
                }
            } else {
                AtomicValue v = valuesIter.nextItem().atomize();
                if (v.getType() == 21) {
                    v = v.convertTo(22);
                }
                si.setValue(v);
            }
            items.add(si);
        }
        FastQSort.sort(items, (int)0, (int)(items.size() - 1));
        SortIndexWorker index = (SortIndexWorker)this.context.getBroker().getIndexController().getWorkerByIndexId(SortIndex.ID);
        try {
            index.createIndex(id, items);
        }
        catch (EXistException e) {
            throw new XPathException((Expression)this, e.getMessage(), (Throwable)e);
        }
        catch (LockException e) {
            throw new XPathException((Expression)this, "Caught lock error while creating index. Giving up.", (Throwable)e);
        }
        return Sequence.EMPTY_SEQUENCE;
    }

    private class SortItemImpl
    implements SortItem {
        NodeProxy node;
        AtomicValue value = AtomicValue.EMPTY_VALUE;

        public SortItemImpl(NodeProxy node) {
            this.node = node;
        }

        @Override
        public NodeProxy getNode() {
            return this.node;
        }

        @Override
        public AtomicValue getValue() {
            return this.value;
        }

        @Override
        public void setValue(AtomicValue value) {
            if (value.hasOne()) {
                this.value = value;
            }
        }

        @Override
        public int compareTo(SortItem other) {
            boolean bIsEmpty;
            int cmp = 0;
            AtomicValue a = this.value;
            AtomicValue b = other.getValue();
            boolean aIsEmpty = a.isEmpty() || Type.subTypeOf((int)a.getType(), (int)30) && ((NumericValue)a).isNaN();
            boolean bl = bIsEmpty = b.isEmpty() || Type.subTypeOf((int)b.getType(), (int)30) && ((NumericValue)b).isNaN();
            if (aIsEmpty) {
                if (bIsEmpty) {
                    return 0;
                }
                cmp = CreateOrderIndex.this.emptyLeast ? -1 : 1;
            } else {
                cmp = bIsEmpty ? (CreateOrderIndex.this.emptyLeast ? 1 : -1) : (a == AtomicValue.EMPTY_VALUE && b != AtomicValue.EMPTY_VALUE ? (CreateOrderIndex.this.emptyLeast ? -1 : 1) : (b == AtomicValue.EMPTY_VALUE && a != AtomicValue.EMPTY_VALUE ? (CreateOrderIndex.this.emptyLeast ? 1 : -1) : a.compareTo((Object)b)));
            }
            if (CreateOrderIndex.this.descending) {
                cmp *= -1;
            }
            return cmp;
        }
    }
}

