/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.sort;

import org.exist.EXistException;
import org.exist.dom.QName;
import org.exist.indexing.sort.SortIndex;
import org.exist.indexing.sort.SortIndexWorker;
import org.exist.util.LockException;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class HasIndex
extends BasicFunction {
    public static final FunctionSignature signature = new FunctionSignature(new QName("has-index", "http://exist-db.org/xquery/sort", "sort"), "Check if the sort index, $id, exists.", new SequenceType[]{new FunctionParameterSequenceType("id", 22, 2, "The name of the index.")}, (SequenceType)new FunctionReturnSequenceType(23, 2, "true() if the sort index, $id, exists, false() otherwise."));

    public HasIndex(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        String id = args[0].getStringValue();
        SortIndexWorker index = (SortIndexWorker)this.context.getBroker().getIndexController().getWorkerByIndexId(SortIndex.ID);
        try {
            return BooleanValue.valueOf((boolean)index.hasIndex(id));
        }
        catch (EXistException e) {
            throw new XPathException((Expression)this, e.getMessage(), (Throwable)e);
        }
        catch (LockException e) {
            throw new XPathException((Expression)this, "Caught lock error while searching index. Giving up.", (Throwable)e);
        }
    }
}

