/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.sort;

import org.exist.EXistException;
import org.exist.dom.QName;
import org.exist.dom.persistent.NodeProxy;
import org.exist.indexing.sort.SortIndex;
import org.exist.indexing.sort.SortIndexWorker;
import org.exist.util.LockException;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class RemoveIndex
extends BasicFunction {
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("remove-index", "http://exist-db.org/xquery/sort", "sort"), "Remove a sort index identified by its name.", new SequenceType[]{new FunctionParameterSequenceType("id", 22, 2, "The name of the index to be removed.")}, (SequenceType)new FunctionReturnSequenceType(11, 7, "")), new FunctionSignature(new QName("remove-index", "http://exist-db.org/xquery/sort", "sort"), "Remove all sort index entries for the given document.", new SequenceType[]{new FunctionParameterSequenceType("id", 22, 2, "The name of the index to be removed."), new FunctionParameterSequenceType("document-node", -1, 2, "A node from the document for which entries should be removed.")}, (SequenceType)new FunctionReturnSequenceType(11, 7, ""))};

    public RemoveIndex(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        SortIndexWorker index = (SortIndexWorker)this.context.getBroker().getIndexController().getWorkerByIndexId(SortIndex.ID);
        String id = args[0].getStringValue();
        try {
            if (this.getArgumentCount() == 2) {
                NodeValue nv = (NodeValue)args[1].itemAt(0);
                if (nv.getImplementationType() == 0) {
                    throw new XPathException((Expression)this, "Second argument to remove should be a persistent node, not an in-memory node.");
                }
                NodeProxy proxy = (NodeProxy)nv;
                index.remove(id, proxy.getOwnerDocument());
            } else {
                index.remove(id);
            }
        }
        catch (EXistException e) {
            throw new XPathException((Expression)this, e.getMessage(), (Throwable)e);
        }
        catch (LockException e) {
            throw new XPathException((Expression)this, "Caught lock error while removing index. Giving up.", (Throwable)e);
        }
        return Sequence.EMPTY_SEQUENCE;
    }
}

