/*
 * Decompiled with CFR 0.152.
 */
package org.exist.indexing.range;

import java.util.LinkedList;
import java.util.List;
import org.exist.dom.QName;
import org.exist.dom.persistent.AbstractCharacterData;
import org.exist.dom.persistent.AttrImpl;
import org.exist.indexing.range.ComplexRangeIndexConfigElement;
import org.exist.indexing.range.RangeIndexConfigField;
import org.exist.indexing.range.TextCollector;
import org.exist.storage.NodePath;

public class ComplexTextCollector
implements TextCollector {
    private NodePath parentPath;
    private ComplexRangeIndexConfigElement config;
    private List<TextCollector.Field> fields = new LinkedList<TextCollector.Field>();
    private RangeIndexConfigField currentField = null;
    private int length = 0;

    public ComplexTextCollector(ComplexRangeIndexConfigElement configuration, NodePath parentPath) {
        this.config = configuration;
        this.parentPath = new NodePath(parentPath, false);
    }

    @Override
    public void startElement(QName qname, NodePath path) {
        RangeIndexConfigField fieldConf = this.config.getField(this.parentPath, path);
        if (fieldConf != null) {
            this.currentField = fieldConf;
            TextCollector.Field field = new TextCollector.Field(this.currentField.getName(), false, fieldConf.whitespaceTreatment(), fieldConf.isCaseSensitive());
            this.fields.add(field);
        }
    }

    @Override
    public void endElement(QName qname, NodePath path) {
        if (this.currentField != null && this.currentField.match(path)) {
            this.currentField = null;
        }
    }

    @Override
    public void attribute(AttrImpl attribute, NodePath path) {
        RangeIndexConfigField fieldConf = this.config.getField(this.parentPath, path);
        if (fieldConf != null) {
            TextCollector.Field field = new TextCollector.Field(fieldConf.getName(), true, fieldConf.whitespaceTreatment(), fieldConf.isCaseSensitive());
            field.content.append(attribute.getValue());
            this.fields.add(0, field);
        }
    }

    @Override
    public void characters(AbstractCharacterData text, NodePath path) {
        TextCollector.Field field;
        if (this.currentField != null && !(field = this.fields.get(this.fields.size() - 1)).isAttribute() && (this.currentField.includeNested() || this.currentField.match(path))) {
            field.content.append(text.getXMLString());
            this.length += text.getXMLString().length();
        }
    }

    @Override
    public boolean hasFields() {
        return true;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public List<TextCollector.Field> getFields() {
        return this.fields;
    }

    public ComplexRangeIndexConfigElement getConfig() {
        return this.config;
    }
}

