/*
 * Decompiled with CFR 0.152.
 */
package org.exist.indexing.range;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.KeywordAnalyzer;
import org.exist.dom.NodeListImpl;
import org.exist.dom.QName;
import org.exist.indexing.range.ComplexRangeIndexConfigElement;
import org.exist.indexing.range.RangeIndexConfigElement;
import org.exist.storage.NodePath;
import org.exist.util.DatabaseConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RangeIndexConfig {
    static final String CONFIG_ROOT = "range";
    static final String CREATE_ELEM = "create";
    private static final String FIELD_ELEM = "field";
    private static final String CONDITION_ELEM = "condition";
    private static final Logger LOG = LogManager.getLogger(RangeIndexConfig.class);
    private Map<QName, RangeIndexConfigElement> paths = new TreeMap<QName, RangeIndexConfigElement>();
    private Analyzer analyzer;
    private PathIterator iterator = new PathIterator();

    public RangeIndexConfig(NodeList configNodes, Map<String, String> namespaces) {
        this.parse(configNodes, namespaces);
    }

    public RangeIndexConfig(RangeIndexConfig other) {
        this.paths = other.paths;
        this.analyzer = other.analyzer;
    }

    public RangeIndexConfigElement find(NodePath path) {
        for (RangeIndexConfigElement rice : this.paths.values()) {
            do {
                if (!rice.find(path) || rice.isComplex()) continue;
                return rice;
            } while ((rice = rice.getNext()) != null);
        }
        return null;
    }

    public List<ComplexRangeIndexConfigElement> findAll(NodePath path) {
        ArrayList<ComplexRangeIndexConfigElement> rices = new ArrayList<ComplexRangeIndexConfigElement>();
        for (RangeIndexConfigElement rice : this.paths.values()) {
            do {
                if (!rice.find(path) || !rice.isComplex()) continue;
                rices.add((ComplexRangeIndexConfigElement)rice);
            } while ((rice = rice.getNext()) != null);
        }
        return rices;
    }

    private void parse(NodeList configNodes, Map<String, String> namespaces) {
        for (int i = 0; i < configNodes.getLength(); ++i) {
            Node node = configNodes.item(i);
            if (node.getNodeType() != 1 || !CONFIG_ROOT.equals(node.getLocalName())) continue;
            this.parseChildren(node.getChildNodes(), namespaces);
        }
    }

    private void parseChildren(NodeList configNodes, Map<String, String> namespaces) {
        for (int i = 0; i < configNodes.getLength(); ++i) {
            Node node = configNodes.item(i);
            if (node.getNodeType() != 1 || !CREATE_ELEM.equals(node.getLocalName())) continue;
            try {
                NodeList fields = this.getFieldsAndConditions((Element)node);
                RangeIndexConfigElement newConfig = fields.getLength() > 0 ? new ComplexRangeIndexConfigElement((Element)node, fields, namespaces) : new RangeIndexConfigElement((Element)node, namespaces);
                RangeIndexConfigElement idxConf = this.paths.get(newConfig.getNodePath().getLastComponent());
                if (idxConf == null) {
                    this.paths.put(newConfig.getNodePath().getLastComponent(), newConfig);
                    continue;
                }
                idxConf.add(newConfig);
                continue;
            }
            catch (DatabaseConfigurationException e) {
                String uri = null;
                Document doc = node.getOwnerDocument();
                if (doc != null) {
                    uri = doc.getDocumentURI();
                }
                if (uri != null) {
                    LOG.error("Invalid range index configuration (" + uri + "): " + e.getMessage());
                    continue;
                }
                LOG.error("Invalid range index configuration: " + e.getMessage());
            }
        }
        this.analyzer = new KeywordAnalyzer();
    }

    public Analyzer getDefaultAnalyzer() {
        return this.analyzer;
    }

    public Analyzer getAnalyzer(QName qname, String fieldName) {
        Analyzer analyzer;
        block2: {
            block1: {
                analyzer = null;
                if (qname == null) break block1;
                RangeIndexConfigElement idxConf = this.paths.get(qname);
                if (idxConf == null) break block2;
                analyzer = idxConf.getAnalyzer(null);
                break block2;
            }
            for (RangeIndexConfigElement idxConf : this.paths.values()) {
                if (idxConf.isComplex() && (analyzer = idxConf.getAnalyzer(fieldName)) != null) break;
            }
        }
        return analyzer;
    }

    public boolean isCaseSensitive(QName qname, String fieldName) {
        boolean caseSensitive;
        block2: {
            block1: {
                caseSensitive = true;
                if (qname == null) break block1;
                RangeIndexConfigElement idxConf = this.paths.get(qname);
                if (idxConf == null) break block2;
                caseSensitive = idxConf.isCaseSensitive(fieldName);
                break block2;
            }
            for (RangeIndexConfigElement idxConf : this.paths.values()) {
                if (idxConf.isComplex() && !(caseSensitive = idxConf.isCaseSensitive(fieldName))) break;
            }
        }
        return caseSensitive;
    }

    public Iterator<RangeIndexConfigElement> getConfig(NodePath path) {
        this.iterator.reset(path);
        return this.iterator;
    }

    private NodeList getFieldsAndConditions(Element root) {
        NodeListImpl fields = new NodeListImpl();
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (node.getNodeType() != 1 || !FIELD_ELEM.equals(node.getLocalName()) && !CONDITION_ELEM.equals(node.getLocalName())) continue;
            fields.add(node);
        }
        return fields;
    }

    public boolean matches(NodePath path) {
        for (RangeIndexConfigElement idxConf = this.paths.get(path.getLastComponent()); idxConf != null; idxConf = idxConf.getNext()) {
            if (!idxConf.match(path)) continue;
            return true;
        }
        return false;
    }

    public int getType(String field) {
        for (RangeIndexConfigElement conf : this.paths.values()) {
            int type;
            if (!conf.isComplex() || (type = conf.getType(field)) == 11) continue;
            return type;
        }
        return 11;
    }

    private class PathIterator
    implements Iterator<RangeIndexConfigElement> {
        private RangeIndexConfigElement nextConfig;
        private NodePath path;
        private boolean atLast = false;

        private PathIterator() {
        }

        protected void reset(NodePath path) {
            this.atLast = false;
            this.path = path;
            this.nextConfig = (RangeIndexConfigElement)RangeIndexConfig.this.paths.get(path.getLastComponent());
            if (this.nextConfig == null) {
                this.atLast = true;
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextConfig != null;
        }

        @Override
        public RangeIndexConfigElement next() {
            if (this.nextConfig == null) {
                return null;
            }
            RangeIndexConfigElement currentConfig = this.nextConfig;
            this.nextConfig = this.nextConfig.getNext();
            if (this.nextConfig == null && !this.atLast) {
                this.atLast = true;
            }
            return currentConfig;
        }

        @Override
        public void remove() {
        }
    }
}

