/*
 * Decompiled with CFR 0.152.
 */
package org.exist.indexing.range;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.exist.dom.QName;
import org.exist.indexing.range.RangeIndex;
import org.exist.indexing.range.RangeIndexConfigCondition;
import org.exist.storage.NodePath;
import org.exist.util.DatabaseConfigurationException;
import org.exist.xquery.Atomize;
import org.exist.xquery.ContextItemDeclaration;
import org.exist.xquery.DynamicCardinalityCheck;
import org.exist.xquery.Expression;
import org.exist.xquery.Function;
import org.exist.xquery.GeneralComparison;
import org.exist.xquery.InternalFunctionCall;
import org.exist.xquery.LiteralValue;
import org.exist.xquery.LocationStep;
import org.exist.xquery.PathExpr;
import org.exist.xquery.Predicate;
import org.exist.xquery.VariableReference;
import org.exist.xquery.XPathException;
import org.exist.xquery.modules.range.RangeQueryRewriter;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.NumericValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.StringValue;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RangeIndexConfigAttributeCondition
extends RangeIndexConfigCondition {
    private final String attributeName;
    private final QName attribute;
    private final String value;
    private final RangeIndex.Operator operator;
    private boolean caseSensitive = true;
    private boolean numericComparison = false;
    private Double numericValue = null;
    private String lowercaseValue = null;
    private Pattern pattern = null;

    public RangeIndexConfigAttributeCondition(Element elem, NodePath parentPath) throws DatabaseConfigurationException {
        if (parentPath.getLastComponent().getNameType() == 1) {
            throw new DatabaseConfigurationException("Range index module: Attribute condition cannot be defined for an attribute:" + parentPath.toString());
        }
        this.attributeName = elem.getAttribute("attribute");
        if (this.attributeName == null || this.attributeName.length() == 0) {
            throw new DatabaseConfigurationException("Range index module: Empty or no attribute qname in condition");
        }
        try {
            this.attribute = new QName(QName.extractLocalName((String)this.attributeName), "", QName.extractPrefix((String)this.attributeName), 1);
        }
        catch (QName.IllegalQNameException e) {
            throw new DatabaseConfigurationException("Rand index module error: " + e.getMessage(), (Throwable)e);
        }
        this.value = elem.getAttribute("value");
        if (elem.hasAttribute("operator")) {
            String operatorName = elem.getAttribute("operator");
            this.operator = RangeIndex.Operator.getByName(operatorName.toLowerCase());
            if (this.operator == null) {
                throw new DatabaseConfigurationException("Range index module: Invalid operator specified in range index condition: " + operatorName + ".");
            }
        } else {
            this.operator = RangeIndex.Operator.EQ;
        }
        String caseString = elem.getAttribute("case");
        String numericString = elem.getAttribute("numeric");
        this.caseSensitive = caseString != null && !caseString.equalsIgnoreCase("no");
        boolean bl = this.numericComparison = numericString != null && numericString.equalsIgnoreCase("yes");
        if (this.operator == RangeIndex.Operator.MATCH) {
            int flags = this.caseSensitive ? 0 : 2;
            try {
                this.pattern = Pattern.compile(this.value, flags);
            }
            catch (PatternSyntaxException e) {
                RangeIndex.LOG.error((Object)e);
                throw new DatabaseConfigurationException("Range index module: Invalid regular expression in condition: " + this.value);
            }
        }
        if (this.numericComparison) {
            switch (this.operator) {
                case MATCH: 
                case STARTS_WITH: 
                case ENDS_WITH: 
                case CONTAINS: {
                    throw new DatabaseConfigurationException("Range index module: Numeric comparison not applicable for operator: " + this.operator.name());
                }
            }
            try {
                this.numericValue = Double.parseDouble(this.value);
            }
            catch (NumberFormatException e) {
                throw new DatabaseConfigurationException("Range index module: Numeric attribute condition specified, but required value cannot be parsed as number: " + this.value);
            }
        }
    }

    private String getLowercaseValue() {
        if (this.lowercaseValue == null && this.value != null) {
            this.lowercaseValue = this.value.toLowerCase();
        }
        return this.lowercaseValue;
    }

    @Override
    public boolean matches(Node node) {
        return node.getNodeType() == 1 && this.matchValue(((Element)node).getAttribute(this.attributeName));
    }

    private boolean matchValue(String testValue) {
        switch (this.operator) {
            case EQ: 
            case NE: {
                boolean matches;
                if (this.numericComparison) {
                    double testDouble = this.toDouble(testValue);
                    matches = this.numericValue.equals(testDouble);
                } else {
                    matches = !this.caseSensitive ? this.value.equalsIgnoreCase(testValue) : this.value.equals(testValue);
                }
                return this.operator == RangeIndex.Operator.EQ ? matches : !matches;
            }
            case GT: 
            case LT: 
            case GE: 
            case LE: {
                int result;
                if (this.numericComparison) {
                    double testDouble = this.toDouble(testValue);
                    result = Double.compare(testDouble, this.numericValue);
                } else {
                    result = !this.caseSensitive ? testValue.toLowerCase().compareTo(this.getLowercaseValue()) : testValue.compareTo(this.value);
                }
                return this.matchOrdinal(this.operator, result);
            }
            case ENDS_WITH: {
                return this.caseSensitive ? testValue.endsWith(this.value) : testValue.toLowerCase().endsWith(this.getLowercaseValue());
            }
            case STARTS_WITH: {
                return this.caseSensitive ? testValue.startsWith(this.value) : testValue.toLowerCase().startsWith(this.getLowercaseValue());
            }
            case CONTAINS: {
                return this.caseSensitive ? testValue.contains(this.value) : testValue.toLowerCase().contains(this.getLowercaseValue());
            }
            case MATCH: {
                Matcher matcher = this.pattern.matcher(testValue);
                return matcher.matches();
            }
        }
        return false;
    }

    private boolean matchOrdinal(RangeIndex.Operator operator, int result) {
        switch (operator) {
            case GT: {
                return result > 0;
            }
            case LT: {
                return result < 0;
            }
            case GE: {
                return result >= 0;
            }
            case LE: {
                return result <= 0;
            }
        }
        return false;
    }

    private Double toDouble(String value) {
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            RangeIndex.LOG.debug("Non-numeric value encountered for numeric condition on @'" + this.attributeName + "': " + value);
            return new Double(0.0);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean find(Predicate predicate) {
        Expression rhe;
        Expression lhe;
        RangeIndex.Operator operator;
        Expression inner = this.getInnerExpression(predicate);
        if (inner instanceof GeneralComparison) {
            GeneralComparison comparison = (GeneralComparison)inner;
            operator = RangeQueryRewriter.getOperator(inner);
            lhe = comparison.getLeft();
            rhe = comparison.getRight();
        } else {
            if (!(inner instanceof InternalFunctionCall)) return false;
            Function func = ((InternalFunctionCall)inner).getFunction();
            if (!func.isCalledAs("matches")) return false;
            operator = RangeIndex.Operator.MATCH;
            lhe = func.getArgument(0);
            rhe = func.getArgument(1);
            lhe = this.unwrapSubExpression(lhe);
            rhe = this.unwrapSubExpression(rhe);
        }
        LocationStep testStep = this.findLocationStep(lhe);
        AtomicValue testValue = this.findAtomicValue(rhe);
        switch (this.operator) {
            case EQ: 
            case NE: {
                if (testStep == null && testValue == null) {
                    testStep = this.findLocationStep(rhe);
                    testValue = this.findAtomicValue(lhe);
                }
            }
            case GT: 
            case LT: 
            case GE: 
            case LE: {
                if (testStep != null || testValue != null) break;
                testStep = this.findLocationStep(rhe);
                testValue = this.findAtomicValue(lhe);
                operator = this.invertOrdinalOperator(operator);
            }
        }
        if (testStep == null || testValue == null) return false;
        QName qname = testStep.getTest().getName();
        try {
            Object foundValue;
            Object requiredValue;
            boolean valueTypeMatches;
            if (this.numericComparison) {
                valueTypeMatches = testValue instanceof NumericValue;
                requiredValue = this.numericValue;
                foundValue = (Comparable)testValue.toJavaObject(Double.class);
            } else {
                valueTypeMatches = testValue instanceof StringValue;
                if (this.caseSensitive) {
                    requiredValue = this.getLowercaseValue();
                    foundValue = testValue.getStringValue().toLowerCase();
                } else {
                    requiredValue = this.value;
                    foundValue = testValue.getStringValue();
                }
            }
            if (qname.getNameType() != 1 || !operator.equals((Object)this.operator) || !qname.equals((Object)this.attribute) || !valueTypeMatches || !foundValue.equals(requiredValue)) return false;
            return true;
        }
        catch (XPathException e) {
            RangeIndex.LOG.error("Value conversion error when testing predicate for condition, value: " + testValue.toString());
            RangeIndex.LOG.error((Object)e);
        }
        return false;
    }

    private Expression unwrapSubExpression(Expression expr) {
        if (expr instanceof Atomize) {
            expr = ((Atomize)expr).getExpression();
        }
        if (expr instanceof DynamicCardinalityCheck && expr.getSubExpressionCount() == 1) {
            expr = expr.getSubExpression(0);
        }
        if (expr instanceof PathExpr && expr.getSubExpressionCount() == 1) {
            expr = expr.getSubExpression(0);
        }
        return expr;
    }

    private LocationStep findLocationStep(Expression expr) {
        if (expr instanceof LocationStep) {
            return (LocationStep)expr;
        }
        return null;
    }

    private AtomicValue findAtomicValue(Expression expr) {
        if (expr instanceof AtomicValue) {
            return (AtomicValue)expr;
        }
        if (expr instanceof LiteralValue) {
            return ((LiteralValue)expr).getValue();
        }
        if (expr instanceof VariableReference || expr instanceof Function) {
            try {
                ContextItemDeclaration cid = expr.getContext().getContextItemDeclartion();
                Sequence contextSequence = cid != null ? cid.eval(null) : null;
                Sequence result = expr.eval(contextSequence);
                if (result instanceof AtomicValue) {
                    return (AtomicValue)result;
                }
            }
            catch (XPathException e) {
                RangeIndex.LOG.error((Object)e);
            }
        }
        return null;
    }

    private RangeIndex.Operator invertOrdinalOperator(RangeIndex.Operator operator) {
        switch (operator) {
            case LE: {
                return RangeIndex.Operator.GE;
            }
            case GE: {
                return RangeIndex.Operator.LE;
            }
            case LT: {
                return RangeIndex.Operator.GT;
            }
            case GT: {
                return RangeIndex.Operator.LT;
            }
        }
        return null;
    }
}

