/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.range;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.exist.collections.Collection;
import org.exist.dom.QName;
import org.exist.dom.persistent.DocumentSet;
import org.exist.dom.persistent.NodeSet;
import org.exist.indexing.range.RangeIndex;
import org.exist.indexing.range.RangeIndexConfig;
import org.exist.indexing.range.RangeIndexWorker;
import org.exist.storage.IndexSpec;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.Atomize;
import org.exist.xquery.Dependency;
import org.exist.xquery.DynamicCardinalityCheck;
import org.exist.xquery.Expression;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Optimizable;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.modules.range.RangeIndexModule;
import org.exist.xquery.util.Error;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.Type;
import org.exist.xquery.value.ValueSequence;

public class FieldLookup
extends Function
implements Optimizable {
    private static final SequenceType[] PARAMETER_TYPE = new SequenceType[]{new FunctionParameterSequenceType("fields", 22, 6, "The name of the field(s) to search"), new FunctionParameterSequenceType("keys", 20, 7, "The keys to look up for each field.")};
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("field", "http://exist-db.org/xquery/range", "range"), "General field lookup function. Normally this will be used by the query optimizer.", new SequenceType[]{new FunctionParameterSequenceType("fields", 22, 6, "The name of the field(s) to search"), new FunctionParameterSequenceType("operators", 22, 6, "The operators to use as strings: eq, lt, gt, contains ..."), new FunctionParameterSequenceType("keys", 20, 7, "The keys to look up for each field.")}, (SequenceType)new FunctionReturnSequenceType(-1, 7, "all nodes from the field set whose node value is equal to the key."), true), new FunctionSignature(new QName("field-eq", "http://exist-db.org/xquery/range", "range"), "General field lookup function based on equality comparison. Normally this will be used by the query optimizer.", PARAMETER_TYPE, (SequenceType)new FunctionReturnSequenceType(-1, 7, "all nodes from the field set whose node value is equal to the key."), true), new FunctionSignature(new QName("field-ne", "http://exist-db.org/xquery/range", "range"), "General field lookup function based on non-equality comparison. Normally this will be used by the query optimizer.", PARAMETER_TYPE, (SequenceType)new FunctionReturnSequenceType(-1, 7, "all nodes from the field set whose node value is not equal to the key."), true), new FunctionSignature(new QName("field-gt", "http://exist-db.org/xquery/range", "range"), "General field lookup function based on greater-than comparison. Normally this will be used by the query optimizer.", PARAMETER_TYPE, (SequenceType)new FunctionReturnSequenceType(-1, 7, "all nodes from the field set whose node value is equal to the key."), true), new FunctionSignature(new QName("field-lt", "http://exist-db.org/xquery/range", "range"), "General field lookup function based on less-than comparison. Normally this will be used by the query optimizer.", PARAMETER_TYPE, (SequenceType)new FunctionReturnSequenceType(-1, 7, "all nodes from the field set whose node value is equal to the key."), true), new FunctionSignature(new QName("field-le", "http://exist-db.org/xquery/range", "range"), "General field lookup function based on less-than-equal comparison. Normally this will be used by the query optimizer.", PARAMETER_TYPE, (SequenceType)new FunctionReturnSequenceType(-1, 7, "all nodes from the field set whose node value is equal to the key."), true), new FunctionSignature(new QName("field-ge", "http://exist-db.org/xquery/range", "range"), "General field lookup function based on greater-than-equal comparison. Normally this will be used by the query optimizer.", PARAMETER_TYPE, (SequenceType)new FunctionReturnSequenceType(-1, 7, "all nodes from the field set whose node value is equal to the key."), true), new FunctionSignature(new QName("field-starts-with", "http://exist-db.org/xquery/range", "range"), "Used by optimizer to optimize a starts-with() function call", PARAMETER_TYPE, (SequenceType)new FunctionReturnSequenceType(-1, 7, "all nodes from the field set whose node value is equal to the key."), true), new FunctionSignature(new QName("field-ends-with", "http://exist-db.org/xquery/range", "range"), "Used by optimizer to optimize a ends-with() function call", PARAMETER_TYPE, (SequenceType)new FunctionReturnSequenceType(-1, 7, "all nodes from the field set whose node value is equal to the key."), true), new FunctionSignature(new QName("field-contains", "http://exist-db.org/xquery/range", "range"), "Used by optimizer to optimize a contains() function call", PARAMETER_TYPE, (SequenceType)new FunctionReturnSequenceType(-1, 7, "all nodes from the field set whose node value is equal to the key."), true), new FunctionSignature(new QName("field-matches", "http://exist-db.org/xquery/range", "range"), "Used by optimizer to optimize a matches() function call", PARAMETER_TYPE, (SequenceType)new FunctionReturnSequenceType(-1, 7, "all nodes from the field set whose node value matches the regular expression."), true)};
    private NodeSet preselectResult = null;
    protected Expression fallback = null;

    public FieldLookup(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public void setFallback(Expression expression) {
        this.fallback = expression;
    }

    public void setArguments(List<Expression> arguments) throws XPathException {
        this.steps.clear();
        Expression path = arguments.get(0);
        path = new DynamicCardinalityCheck(this.context, 6, path, new Error("D02", (Object)"1", (Object)this.mySignature));
        this.steps.add(path);
        int j = 1;
        if (this.isCalledAs("field")) {
            Expression fields = arguments.get(1);
            fields = new DynamicCardinalityCheck(this.context, 6, fields, new Error("D02", (Object)"2", (Object)this.mySignature));
            this.steps.add(fields);
            ++j;
        }
        for (int i = j; i < arguments.size(); ++i) {
            Expression arg = arguments.get(i).simplify();
            arg = new DynamicCardinalityCheck(this.context, 6, arg, new Error("D02", (Object)"1", (Object)this.mySignature));
            this.steps.add(arg);
        }
    }

    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        super.analyze(new AnalyzeContextInfo(contextInfo));
        this.contextId = contextInfo.getContextId();
    }

    public NodeSet preSelect(Sequence contextSequence, boolean useContext) throws XPathException {
        int i;
        if (contextSequence != null && !contextSequence.isPersistentSet()) {
            return NodeSet.EMPTY_SET;
        }
        long start = System.currentTimeMillis();
        this.preselectResult = null;
        Sequence fieldSeq = this.getArgument(0).eval(contextSequence);
        RangeIndex.Operator[] operators = null;
        int j = 1;
        if (this.isCalledAs("field")) {
            Sequence operatorSeq = this.getArgument(1).eval(contextSequence);
            operators = new RangeIndex.Operator[operatorSeq.getItemCount()];
            i = 0;
            SequenceIterator si = operatorSeq.iterate();
            while (si.hasNext()) {
                operators[i] = RangeIndexModule.OPERATOR_MAP.get(si.nextItem().getStringValue());
                ++i;
            }
            ++j;
        } else {
            RangeIndex.Operator operator = this.getOperator();
            operators = new RangeIndex.Operator[fieldSeq.getItemCount()];
            for (i = 0; i < operators.length; ++i) {
                operators[i] = operator;
            }
        }
        Object[] keys = new Sequence[this.getArgumentCount() - j];
        for (i = j; i < this.getArgumentCount(); ++i) {
            keys[i - j] = Atomize.atomize((Sequence)this.getArgument(i).eval(contextSequence));
        }
        DocumentSet docs = contextSequence.getDocumentSet();
        RangeIndexWorker index = (RangeIndexWorker)this.context.getBroker().getIndexController().getWorkerByIndexId(RangeIndex.ID);
        try {
            this.preselectResult = index.queryField(this.getExpressionId(), docs, useContext ? contextSequence.toNodeSet() : null, fieldSeq, (Sequence[])keys, operators, 1);
        }
        catch (IOException e) {
            throw new XPathException((Expression)this, "Error while querying full text index: " + e.getMessage(), (Throwable)e);
        }
        LOG.info("preselect for " + Arrays.toString(keys) + " on " + contextSequence.getItemCount() + "returned " + this.preselectResult.getItemCount() + " and took " + (System.currentTimeMillis() - start));
        if (this.context.getProfiler().traceFunctions()) {
            this.context.getProfiler().traceIndexUsage(this.context, "new-range", (Expression)this, 2, System.currentTimeMillis() - start);
        }
        return this.preselectResult;
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        NodeSet result;
        if (contextItem != null) {
            contextSequence = contextItem.toSequence();
        }
        if (contextSequence != null && !contextSequence.isPersistentSet()) {
            if (this.fallback == null) {
                return Sequence.EMPTY_SEQUENCE;
            }
            return this.fallback.eval(contextSequence, contextItem);
        }
        if (this.preselectResult == null) {
            int i;
            long start = System.currentTimeMillis();
            DocumentSet docs = contextSequence == null ? this.context.getStaticallyKnownDocuments() : contextSequence.getDocumentSet();
            NodeSet contextSet = null;
            if (contextSequence != null) {
                contextSet = contextSequence.toNodeSet();
            }
            Sequence fields = this.getArgument(0).eval(contextSequence);
            RangeIndex.Operator[] operators = null;
            int j = 1;
            if (this.isCalledAs("field")) {
                Sequence operatorSeq = this.getArgument(1).eval(contextSequence);
                operators = new RangeIndex.Operator[operatorSeq.getItemCount()];
                i = 0;
                SequenceIterator si = operatorSeq.iterate();
                while (si.hasNext()) {
                    operators[i] = RangeIndexModule.OPERATOR_MAP.get(si.nextItem().getStringValue());
                    ++i;
                }
                ++j;
            } else {
                RangeIndex.Operator operator = this.getOperator();
                operators = new RangeIndex.Operator[fields.getItemCount()];
                for (i = 0; i < operators.length; ++i) {
                    operators[i] = operator;
                }
            }
            if (operators.length != fields.getItemCount()) {
                throw new XPathException((Expression)this, "Number of operators specified must correspond to number of fields queried");
            }
            Sequence[] keys = new Sequence[this.getArgumentCount() - j];
            SequenceIterator fieldIter = fields.unorderedIterator();
            for (int i2 = j; i2 < this.getArgumentCount(); ++i2) {
                keys[i2 - j] = this.getArgument(i2).eval(contextSequence);
                int targetType = 11;
                if (fieldIter.hasNext()) {
                    String field = fieldIter.nextItem().getStringValue();
                    targetType = this.getType(contextSequence, field);
                }
                if (targetType == 11 || Type.subTypeOf((int)keys[i2 - j].getItemType(), (int)targetType)) continue;
                if (keys[i2 - j].hasMany()) {
                    ValueSequence temp = new ValueSequence(keys[i2 - j].getItemCount());
                    SequenceIterator iterator = keys[i2 - j].unorderedIterator();
                    while (iterator.hasNext()) {
                        temp.add((Item)iterator.nextItem().convertTo(targetType));
                    }
                    keys[i2 - j] = temp;
                    continue;
                }
                keys[i2 - j] = keys[i2 - j].convertTo(targetType);
            }
            if (keys.length < fields.getItemCount()) {
                throw new XPathException((Expression)this, "Number of keys to look up must correspond to number of fields specified");
            }
            RangeIndexWorker index = (RangeIndexWorker)this.context.getBroker().getIndexController().getWorkerByIndexId(RangeIndex.ID);
            try {
                result = index.queryField(this.getExpressionId(), docs, contextSet, fields, keys, operators, 1);
                if (contextSet != null) {
                    result = this.fallback != null && (this.fallback.getPrimaryAxis() == 5 || this.fallback.getPrimaryAxis() == 6) ? result.selectParentChild(contextSet, 1, this.getContextId()) : result.selectAncestorDescendant(contextSet, 1, true, this.getContextId(), true);
                }
            }
            catch (IOException e) {
                throw new XPathException((Expression)this, e.getMessage());
            }
            if (this.context.getProfiler().traceFunctions()) {
                this.context.getProfiler().traceIndexUsage(this.context, "new-range", (Expression)this, 2, System.currentTimeMillis() - start);
            }
        } else {
            result = this.preselectResult.selectAncestorDescendant(contextSequence.toNodeSet(), 1, true, this.getContextId(), true);
        }
        return result;
    }

    private RangeIndex.Operator getOperator() {
        String calledAs = this.getSignature().getName().getLocalPart();
        return RangeIndexModule.OPERATOR_MAP.get(calledAs.substring("field-".length()));
    }

    public int getType(Sequence contextSequence, String field) {
        if (contextSequence == null) {
            return 11;
        }
        Iterator i = contextSequence.getCollectionIterator();
        while (i.hasNext()) {
            int type;
            RangeIndexConfig config;
            IndexSpec idxConf;
            Collection collection = (Collection)i.next();
            if (collection.getURI().startsWith(XmldbURI.SYSTEM_COLLECTION_URI) || (idxConf = collection.getIndexConfiguration(this.context.getBroker())) == null || (config = (RangeIndexConfig)idxConf.getCustomIndexSpec(RangeIndex.ID)) == null || (type = config.getType(field)) == 11) continue;
            return type;
        }
        return 11;
    }

    public boolean canOptimize(Sequence contextSequence) {
        return true;
    }

    public boolean optimizeOnSelf() {
        return false;
    }

    public boolean optimizeOnChild() {
        return true;
    }

    public int getOptimizeAxis() {
        return 5;
    }

    public int getDependencies() {
        Expression stringArg = this.getArgument(0);
        if (!Dependency.dependsOn((Expression)stringArg, (int)2)) {
            return 1;
        }
        return 3;
    }

    public int returnsType() {
        return -1;
    }

    public void resetState(boolean postOptimization) {
        super.resetState(postOptimization);
        if (this.fallback != null) {
            this.fallback.resetState(postOptimization);
        }
        if (!postOptimization) {
            this.preselectResult = null;
        }
    }
}

