/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.range;

import org.exist.dom.QName;
import org.exist.indexing.range.RangeIndexWorker;
import org.exist.util.Occurrences;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReference;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.ValueSequence;

public class IndexKeys
extends BasicFunction {
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("index-keys-for-field", "http://exist-db.org/xquery/range", "range"), "Retrieve all index keys contained in a range index which has been defined with a field name. Similar toutil:index-keys, but works with fields.", new SequenceType[]{new FunctionParameterSequenceType("field", 22, 2, "The field to use"), new FunctionParameterSequenceType("function-reference", 101, 2, "The function reference as created by the util:function function. It can be an arbitrary user-defined function, but it should take exactly 2 arguments: 1) the current index key as found in the range index as an atomic value, 2) a sequence containing three int values: a) the overall frequency of the key within the node set, b) the number of distinct documents in the node set the key occurs in, c) the current position of the key in the whole list of keys returned."), new FunctionParameterSequenceType("max-number-returned", 38, 3, "The maximum number of returned keys")}, (SequenceType)new FunctionReturnSequenceType(11, 7, "the results of the eval of the $function-reference")), new FunctionSignature(new QName("index-keys-for-field", "http://exist-db.org/xquery/range", "range"), "Retrieve all index keys contained in a range index which has been defined with a field name. Similar toutil:index-keys, but works with fields.", new SequenceType[]{new FunctionParameterSequenceType("field", 22, 2, "The field to use"), new FunctionParameterSequenceType("start-value", 20, 3, "Only index keys of the same type but being greater than $start-value will be reported for non-string types. For string types, only keys starting with the given prefix are reported."), new FunctionParameterSequenceType("function-reference", 101, 2, "The function reference as created by the util:function function. It can be an arbitrary user-defined function, but it should take exactly 2 arguments: 1) the current index key as found in the range index as an atomic value, 2) a sequence containing three int values: a) the overall frequency of the key within the node set, b) the number of distinct documents in the node set the key occurs in, c) the current position of the key in the whole list of keys returned."), new FunctionParameterSequenceType("max-number-returned", 38, 3, "The maximum number of returned keys")}, (SequenceType)new FunctionReturnSequenceType(11, 7, "the results of the eval of the $function-reference"))};

    public IndexKeys(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        int arg = 0;
        String field = args[arg++].getStringValue();
        String start = null;
        if (args.length == 4) {
            start = args[arg++].getStringValue();
        }
        FunctionReference ref = (FunctionReference)args[arg++].itemAt(0);
        int max = -1;
        if (!args[arg].isEmpty()) {
            max = ((IntegerValue)args[arg].itemAt(0)).getInt();
        }
        ValueSequence result = new ValueSequence();
        RangeIndexWorker worker = (RangeIndexWorker)this.context.getBroker().getIndexController().getWorkerByIndexName("range-index");
        Occurrences[] occur = worker.scanIndexByField(field, contextSequence == null ? this.context.getStaticallyKnownDocuments() : contextSequence.getDocumentSet(), start, max);
        int len = max != -1 && occur.length > max ? max : occur.length;
        Sequence[] params = new Sequence[2];
        ValueSequence data = new ValueSequence();
        for (int j = 0; j < len; ++j) {
            params[0] = new StringValue(occur[j].getTerm().toString());
            data.add((Item)new IntegerValue((long)occur[j].getOccurrences(), 43));
            data.add((Item)new IntegerValue((long)occur[j].getDocuments(), 43));
            data.add((Item)new IntegerValue((long)(j + 1), 43));
            params[1] = data;
            result.addAll(ref.evalFunction(Sequence.EMPTY_SEQUENCE, null, params));
            data.clear();
        }
        return result;
    }
}

