/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.range;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import org.exist.collections.Collection;
import org.exist.dom.QName;
import org.exist.indexing.range.ComplexRangeIndexConfigElement;
import org.exist.indexing.range.RangeIndex;
import org.exist.indexing.range.RangeIndexConfig;
import org.exist.indexing.range.RangeIndexConfigElement;
import org.exist.indexing.range.RangeIndexConfigField;
import org.exist.storage.IndexSpec;
import org.exist.storage.NodePath;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.Expression;
import org.exist.xquery.FilteredExpression;
import org.exist.xquery.Function;
import org.exist.xquery.GeneralComparison;
import org.exist.xquery.InternalFunctionCall;
import org.exist.xquery.LiteralValue;
import org.exist.xquery.LocationStep;
import org.exist.xquery.Pragma;
import org.exist.xquery.Predicate;
import org.exist.xquery.RewritableExpression;
import org.exist.xquery.SequenceConstructor;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.modules.range.FieldLookup;
import org.exist.xquery.modules.range.Lookup;
import org.exist.xquery.modules.range.RangeQueryRewriter;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.StringValue;

public class OptimizeFieldPragma
extends Pragma {
    public static final QName OPTIMIZE_RANGE_PRAGMA = new QName("optimize-field", "http://exist.sourceforge.net/NS/exist", "exist");
    private final XQueryContext context;
    private Expression rewritten = null;
    private AnalyzeContextInfo contextInfo;
    private int axis;

    public OptimizeFieldPragma(QName qname, String contents, XQueryContext context) throws XPathException {
        super(qname, contents);
        this.context = context;
    }

    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        super.analyze(contextInfo);
        this.contextInfo = contextInfo;
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        if (this.rewritten != null) {
            this.rewritten.analyze(this.contextInfo);
            return this.rewritten.eval(contextSequence, contextItem);
        }
        return null;
    }

    public void before(XQueryContext context, Expression expression, Sequence contextSequence) throws XPathException {
        LocationStep locationStep = (LocationStep)expression;
        if (locationStep.hasPredicates()) {
            Expression parentExpr = locationStep.getParentExpression();
            if (!(parentExpr instanceof RewritableExpression)) {
                return;
            }
            List preds = locationStep.getPredicates();
            NodePath contextPath = RangeQueryRewriter.toNodePath(RangeQueryRewriter.getPrecedingSteps(locationStep));
            this.rewritten = this.tryRewriteToFields(locationStep, preds, contextPath, contextSequence);
            this.axis = locationStep.getAxis();
        }
    }

    public void after(XQueryContext context, Expression expression) throws XPathException {
    }

    private Expression tryRewriteToFields(LocationStep locationStep, List<Predicate> preds, NodePath contextPath, Sequence contextSequence) throws XPathException {
        if (contextPath != null) {
            ArrayList<Predicate> notOptimizable = new ArrayList<Predicate>(preds.size());
            List<RangeIndexConfig> configs = this.getConfigurations(contextSequence);
            IdentityHashMap predicateArgs = new IdentityHashMap(preds.size());
            for (Predicate pred : preds) {
                ArrayList<Object> args = null;
                SequenceConstructor arg0 = null;
                SequenceConstructor arg1 = null;
                if (pred.getLength() != 1) {
                    notOptimizable.add(pred);
                    continue;
                }
                Expression innerExpr = pred.getExpression(0);
                List<LocationStep> steps = RangeQueryRewriter.getStepsToOptimize(innerExpr);
                if (steps == null) {
                    notOptimizable.add(pred);
                    continue;
                }
                NodePath innerPath = RangeQueryRewriter.toNodePath(steps);
                if (innerPath == null) {
                    notOptimizable.add(pred);
                    continue;
                }
                NodePath path = new NodePath(contextPath);
                path.append(innerPath);
                if (path.length() > 0) {
                    List<ComplexRangeIndexConfigElement> rices = this.findConfigurations(path, configs);
                    rices.sort(ComplexRangeIndexConfigElement.NUM_CONDITIONS_COMPARATOR);
                    if (rices.isEmpty()) {
                        notOptimizable.add(pred);
                        continue;
                    }
                    RangeIndexConfigElement rice = null;
                    List<Predicate> precedingPreds = preds.subList(0, preds.indexOf(pred));
                    ArrayList<Predicate> matchedPreds = new ArrayList<Predicate>();
                    for (ComplexRangeIndexConfigElement testRice : rices) {
                        if (testRice.getNumberOfConditions() > 0) {
                            matchedPreds.clear();
                            for (Predicate precedingPred : precedingPreds) {
                                if (!testRice.findCondition(precedingPred)) continue;
                                matchedPreds.add(precedingPred);
                            }
                            if (matchedPreds.size() != testRice.getNumberOfConditions()) continue;
                            rice = testRice;
                            predicateArgs.keySet().removeAll(matchedPreds);
                            notOptimizable.removeAll(matchedPreds);
                            break;
                        }
                        rice = testRice;
                    }
                    if (rice != null && rice.getNodePath().match(contextPath)) {
                        RangeIndexConfigField field = ((ComplexRangeIndexConfigElement)rice).getField(path);
                        if (field != null) {
                            if (args == null) {
                                args = new ArrayList<Object>(4);
                                arg0 = new SequenceConstructor(this.context);
                                args.add(arg0);
                                arg1 = new SequenceConstructor(this.context);
                                args.add(arg1);
                            }
                            arg0.add((Expression)new LiteralValue(this.context, (AtomicValue)new StringValue(field.getName())));
                            arg1.add((Expression)new LiteralValue(this.context, (AtomicValue)new StringValue(RangeQueryRewriter.getOperator(innerExpr).toString())));
                            args.add(this.getKeyArg(innerExpr));
                            predicateArgs.put(pred, args);
                            continue;
                        }
                        notOptimizable.add(pred);
                        continue;
                    }
                    notOptimizable.add(pred);
                    continue;
                }
                notOptimizable.add(pred);
            }
            if (!predicateArgs.isEmpty()) {
                FieldLookup func = new FieldLookup(this.context, FieldLookup.signatures[0]);
                func.setFallback((Expression)locationStep);
                func.setLocation(locationStep.getLine(), locationStep.getColumn());
                if (predicateArgs.size() == 1) {
                    func.setArguments((List)predicateArgs.entrySet().iterator().next().getValue());
                } else {
                    ArrayList<Expression> mergedArgs = new ArrayList<Expression>(predicateArgs.size() * 4);
                    SequenceConstructor arg0 = new SequenceConstructor(this.context);
                    mergedArgs.add((Expression)arg0);
                    SequenceConstructor arg1 = new SequenceConstructor(this.context);
                    mergedArgs.add((Expression)arg1);
                    for (List args : predicateArgs.values()) {
                        arg0.add((Expression)args.get(0));
                        arg1.add((Expression)args.get(1));
                        mergedArgs.addAll(args.subList(2, args.size()));
                    }
                    func.setArguments(mergedArgs);
                }
                InternalFunctionCall optimizedExpr = new InternalFunctionCall((Function)func);
                if (notOptimizable.size() > 0) {
                    FilteredExpression filtered = new FilteredExpression(this.context, (Expression)optimizedExpr);
                    for (Predicate pred : notOptimizable) {
                        filtered.addPredicate(pred);
                    }
                    optimizedExpr = filtered;
                }
                return optimizedExpr;
            }
        }
        return null;
    }

    private Expression getKeyArg(Expression expression) {
        InternalFunctionCall fcall;
        Function function;
        if (expression instanceof GeneralComparison) {
            return ((GeneralComparison)expression).getRight();
        }
        if (expression instanceof InternalFunctionCall && (function = (fcall = (InternalFunctionCall)expression).getFunction()) instanceof Lookup) {
            return function.getArgument(1);
        }
        return null;
    }

    private List<ComplexRangeIndexConfigElement> findConfigurations(NodePath path, List<RangeIndexConfig> configs) {
        RangeIndexConfig config;
        List<ComplexRangeIndexConfigElement> foundRices;
        ArrayList<ComplexRangeIndexConfigElement> rices = new ArrayList<ComplexRangeIndexConfigElement>();
        Iterator<RangeIndexConfig> iterator = configs.iterator();
        while (iterator.hasNext() && !rices.addAll(foundRices = (config = iterator.next()).findAll(path))) {
        }
        return rices;
    }

    private List<RangeIndexConfig> getConfigurations(Sequence contextSequence) {
        ArrayList<RangeIndexConfig> configs = new ArrayList<RangeIndexConfig>();
        Iterator i = contextSequence.getCollectionIterator();
        while (i.hasNext()) {
            RangeIndexConfig config;
            IndexSpec idxConf;
            Collection collection = (Collection)i.next();
            if (collection.getURI().startsWith(XmldbURI.SYSTEM_COLLECTION_URI) || (idxConf = collection.getIndexConfiguration(this.context.getBroker())) == null || (config = (RangeIndexConfig)idxConf.getCustomIndexSpec(RangeIndex.ID)) == null) continue;
            configs.add(config);
        }
        return configs;
    }
}

