/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.logging;

import org.jgroups.logging.CustomLogFactory;
import org.jgroups.logging.JDKLogImpl;
import org.jgroups.logging.Log;
import org.jgroups.logging.Log4J2LogImpl;
import org.jgroups.logging.Log4JLogImpl;

public class LogFactory {
    public static final boolean IS_LOG4J2_AVAILABLE;
    public static final boolean IS_LOG4J_AVAILABLE;
    protected static final boolean USE_JDK_LOGGER;
    protected static final CustomLogFactory custom_log_factory;

    public static String loggerType() {
        if (USE_JDK_LOGGER) {
            return "jdk";
        }
        if (IS_LOG4J2_AVAILABLE) {
            return "log4j2";
        }
        if (IS_LOG4J_AVAILABLE) {
            return "log4j";
        }
        return "jdk";
    }

    protected static boolean isAvailable(String classname) {
        try {
            return Class.forName(classname) != null;
        }
        catch (ClassNotFoundException cnfe) {
            return false;
        }
    }

    protected static boolean isPropertySet(String property_name) {
        try {
            return Boolean.parseBoolean(System.getProperty(property_name));
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static Log getLog(Class clazz) {
        if (custom_log_factory != null) {
            return custom_log_factory.getLog(clazz);
        }
        if (USE_JDK_LOGGER) {
            return new JDKLogImpl(clazz);
        }
        if (IS_LOG4J2_AVAILABLE) {
            return new Log4J2LogImpl(clazz);
        }
        if (IS_LOG4J_AVAILABLE) {
            return new Log4JLogImpl(clazz);
        }
        return new JDKLogImpl(clazz);
    }

    public static Log getLog(String category) {
        if (custom_log_factory != null) {
            return custom_log_factory.getLog(category);
        }
        if (USE_JDK_LOGGER) {
            return new JDKLogImpl(category);
        }
        if (IS_LOG4J2_AVAILABLE) {
            return new Log4J2LogImpl(category);
        }
        if (IS_LOG4J_AVAILABLE) {
            return new Log4JLogImpl(category);
        }
        return new JDKLogImpl(category);
    }

    static {
        String customLogFactoryClass = System.getProperty("jgroups.logging.log_factory_class");
        CustomLogFactory customLogFactoryX = null;
        if (customLogFactoryClass != null) {
            try {
                customLogFactoryX = (CustomLogFactory)Class.forName(customLogFactoryClass).newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        custom_log_factory = customLogFactoryX;
        USE_JDK_LOGGER = LogFactory.isPropertySet("jgroups.use.jdk_logger");
        IS_LOG4J_AVAILABLE = LogFactory.isAvailable("org.apache.log4j.Logger");
        IS_LOG4J2_AVAILABLE = LogFactory.isAvailable("org.apache.logging.log4j.core.Logger");
    }
}

