/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.tom;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.protocols.tom.DeliveryManager;
import org.jgroups.protocols.tom.MessageID;

public class DeliveryManagerImpl
implements DeliveryManager {
    private static final MessageInfoComparator COMPARATOR = new MessageInfoComparator();
    private final SortedSet<MessageInfo> deliverySet = new TreeSet<MessageInfo>(COMPARATOR);
    private final ConcurrentMap<MessageID, MessageInfo> messageCache = new ConcurrentHashMap<MessageID, MessageInfo>(8192, 0.75f, 64);
    private final Set<Message> singleDestinationSet = new HashSet<Message>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNewMessageToDeliver(MessageID messageID, Message message, long sequenceNumber) {
        MessageInfo messageInfo = new MessageInfo(messageID, message, sequenceNumber);
        SortedSet<MessageInfo> sortedSet = this.deliverySet;
        synchronized (sortedSet) {
            this.deliverySet.add(messageInfo);
        }
        this.messageCache.put(messageID, messageInfo);
    }

    public void markReadyToDeliver(MessageID messageID, long finalSequenceNumber) {
        this.markReadyToDeliverV2(messageID, finalSequenceNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markReadyToDeliverV1(MessageID messageID, long finalSequenceNumber) {
        SortedSet<MessageInfo> sortedSet = this.deliverySet;
        synchronized (sortedSet) {
            MessageInfo messageInfo = null;
            boolean needsUpdatePosition = false;
            Iterator iterator = this.deliverySet.iterator();
            while (iterator.hasNext()) {
                MessageInfo aux = (MessageInfo)iterator.next();
                if (!aux.equals(messageID)) continue;
                messageInfo = aux;
                if (messageInfo.sequenceNumber == finalSequenceNumber) break;
                needsUpdatePosition = true;
                iterator.remove();
                break;
            }
            if (messageInfo == null) {
                throw new IllegalStateException("Message ID not found in to deliver list. this can't happen. Message ID is " + messageID);
            }
            messageInfo.updateAndmarkReadyToDeliver(finalSequenceNumber);
            if (needsUpdatePosition) {
                this.deliverySet.add(messageInfo);
            }
            if (!this.deliverySet.isEmpty() && this.deliverySet.first().isReadyToDeliver()) {
                this.deliverySet.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markReadyToDeliverV2(MessageID messageID, long finalSequenceNumber) {
        MessageInfo messageInfo = (MessageInfo)this.messageCache.remove(messageID);
        if (messageInfo == null) {
            throw new IllegalStateException("Message ID not found in to deliver list. this can't happen. Message ID is " + messageID);
        }
        boolean needsUpdatePosition = messageInfo.isUpdatePositionNeeded(finalSequenceNumber);
        SortedSet<MessageInfo> sortedSet = this.deliverySet;
        synchronized (sortedSet) {
            if (needsUpdatePosition) {
                this.deliverySet.remove(messageInfo);
                messageInfo.updateAndmarkReadyToDeliver(finalSequenceNumber);
                this.deliverySet.add(messageInfo);
            } else {
                messageInfo.updateAndmarkReadyToDeliver(finalSequenceNumber);
            }
            if (this.deliverySet.first().isReadyToDeliver()) {
                this.deliverySet.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeLeavers(Collection<Address> leavers) {
        if (leavers == null) {
            return;
        }
        LinkedList<MessageInfo> toRemove = new LinkedList<MessageInfo>();
        SortedSet<MessageInfo> sortedSet = this.deliverySet;
        synchronized (sortedSet) {
            for (MessageInfo messageInfo : this.deliverySet) {
                if (!leavers.contains(messageInfo.getMessage().getSrc()) || messageInfo.isReadyToDeliver()) continue;
                toRemove.add(messageInfo);
            }
            this.deliverySet.removeAll(toRemove);
            if (!this.deliverySet.isEmpty() && this.deliverySet.first().isReadyToDeliver()) {
                this.deliverySet.notify();
            }
        }
        for (MessageInfo removed : toRemove) {
            this.messageCache.remove(removed.messageID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Message> getNextMessagesToDeliver() throws InterruptedException {
        LinkedList<Message> toDeliver = new LinkedList<Message>();
        SortedSet<MessageInfo> sortedSet = this.deliverySet;
        synchronized (sortedSet) {
            MessageInfo messageInfo;
            while (this.deliverySet.isEmpty() && this.singleDestinationSet.isEmpty()) {
                this.deliverySet.wait();
            }
            if (!this.singleDestinationSet.isEmpty()) {
                toDeliver.addAll(this.singleDestinationSet);
                this.singleDestinationSet.clear();
                return toDeliver;
            }
            if (!this.deliverySet.first().isReadyToDeliver()) {
                this.deliverySet.wait();
            }
            if (!this.singleDestinationSet.isEmpty()) {
                toDeliver.addAll(this.singleDestinationSet);
                this.singleDestinationSet.clear();
            }
            Iterator iterator = this.deliverySet.iterator();
            while (iterator.hasNext() && (messageInfo = (MessageInfo)iterator.next()).isReadyToDeliver()) {
                toDeliver.add(messageInfo.getMessage());
                iterator.remove();
            }
        }
        return toDeliver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        SortedSet<MessageInfo> sortedSet = this.deliverySet;
        synchronized (sortedSet) {
            this.deliverySet.clear();
            this.messageCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deliverSingleDestinationMessage(Message msg) {
        SortedSet<MessageInfo> sortedSet = this.deliverySet;
        synchronized (sortedSet) {
            this.singleDestinationSet.add(msg);
            this.deliverySet.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<MessageInfo> getMessageSet() {
        SortedSet<MessageInfo> sortedSet = this.deliverySet;
        synchronized (sortedSet) {
            return Collections.unmodifiableSet(this.deliverySet);
        }
    }

    private static class MessageInfoComparator
    implements Comparator<MessageInfo> {
        private MessageInfoComparator() {
        }

        @Override
        public int compare(MessageInfo messageInfo, MessageInfo messageInfo1) {
            if (messageInfo == null) {
                return messageInfo1 == null ? 0 : 1;
            }
            if (messageInfo1 == null) {
                return -1;
            }
            int compareMessageID = messageInfo.messageID.compareTo(messageInfo1.messageID);
            if (compareMessageID == 0) {
                return 0;
            }
            if (messageInfo.sequenceNumber != messageInfo1.sequenceNumber) {
                return Long.signum(messageInfo.sequenceNumber - messageInfo1.sequenceNumber);
            }
            return compareMessageID;
        }
    }

    private static class MessageInfo {
        private MessageID messageID;
        private Message message;
        private volatile long sequenceNumber;
        private volatile boolean readyToDeliver;

        public MessageInfo(MessageID messageID, Message message, long sequenceNumber) {
            if (messageID == null) {
                throw new NullPointerException("Message ID can't be null");
            }
            this.messageID = messageID;
            this.message = message.copy(true, true);
            this.sequenceNumber = sequenceNumber;
            this.readyToDeliver = false;
            this.message.setSrc(messageID.getAddress());
        }

        private Message getMessage() {
            return this.message;
        }

        private void updateAndmarkReadyToDeliver(long finalSequenceNumber) {
            this.readyToDeliver = true;
            this.sequenceNumber = finalSequenceNumber;
        }

        private boolean isReadyToDeliver() {
            return this.readyToDeliver;
        }

        public boolean equals(Object o) {
            boolean isMessageID;
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            boolean bl = isMessageID = o.getClass() == MessageID.class;
            if (o.getClass() != this.getClass() && !isMessageID) {
                return false;
            }
            if (isMessageID) {
                return this.messageID.equals(o);
            }
            MessageInfo that = (MessageInfo)o;
            return this.messageID.equals(that.messageID);
        }

        public int hashCode() {
            return this.messageID.hashCode();
        }

        public String toString() {
            return "MessageInfo{messageID=" + this.messageID + ", sequenceNumber=" + this.sequenceNumber + ", readyToDeliver=" + this.readyToDeliver + '}';
        }

        public boolean isUpdatePositionNeeded(long finalSequenceNumber) {
            return this.sequenceNumber != finalSequenceNumber;
        }
    }
}

