/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdeparser;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jboss.jdeparser.JAnnotatable;
import org.jboss.jdeparser.JAnnotationStringValue;
import org.jboss.jdeparser.JAnnotationUse;
import org.jboss.jdeparser.JAnnotationValue;
import org.jboss.jdeparser.JAnnotationWriter;
import org.jboss.jdeparser.JClass;
import org.jboss.jdeparser.JDeparser;
import org.jboss.jdeparser.JEnumConstant;
import org.jboss.jdeparser.JExpr;
import org.jboss.jdeparser.JExpression;
import org.jboss.jdeparser.JExpressionImpl;
import org.jboss.jdeparser.JFormatter;
import org.jboss.jdeparser.JType;
import org.jboss.jdeparser.TypedAnnotationWriter;

public final class JAnnotationArrayMember
extends JAnnotationValue
implements JAnnotatable {
    private final List<JAnnotationValue> values = new ArrayList<JAnnotationValue>();
    private final JDeparser owner;

    JAnnotationArrayMember(JDeparser owner) {
        this.owner = owner;
    }

    public JAnnotationArrayMember param(String value) {
        JAnnotationStringValue annotationValue = new JAnnotationStringValue(JExpr.lit(value));
        this.values.add(annotationValue);
        return this;
    }

    public JAnnotationArrayMember param(boolean value) {
        JAnnotationStringValue annotationValue = new JAnnotationStringValue(JExpr.lit(value));
        this.values.add(annotationValue);
        return this;
    }

    public JAnnotationArrayMember param(byte value) {
        JAnnotationStringValue annotationValue = new JAnnotationStringValue(JExpr.lit(value));
        this.values.add(annotationValue);
        return this;
    }

    public JAnnotationArrayMember param(char value) {
        JAnnotationStringValue annotationValue = new JAnnotationStringValue(JExpr.lit(value));
        this.values.add(annotationValue);
        return this;
    }

    public JAnnotationArrayMember param(double value) {
        JAnnotationStringValue annotationValue = new JAnnotationStringValue(JExpr.lit(value));
        this.values.add(annotationValue);
        return this;
    }

    public JAnnotationArrayMember param(long value) {
        JAnnotationStringValue annotationValue = new JAnnotationStringValue(JExpr.lit(value));
        this.values.add(annotationValue);
        return this;
    }

    public JAnnotationArrayMember param(short value) {
        JAnnotationStringValue annotationValue = new JAnnotationStringValue(JExpr.lit(value));
        this.values.add(annotationValue);
        return this;
    }

    public JAnnotationArrayMember param(int value) {
        JAnnotationStringValue annotationValue = new JAnnotationStringValue(JExpr.lit(value));
        this.values.add(annotationValue);
        return this;
    }

    public JAnnotationArrayMember param(float value) {
        JAnnotationStringValue annotationValue = new JAnnotationStringValue(JExpr.lit(value));
        this.values.add(annotationValue);
        return this;
    }

    public JAnnotationArrayMember param(final Enum<?> value) {
        JAnnotationValue annotationValue = new JAnnotationValue(){

            @Override
            public void generate(JFormatter f) {
                f.t(JAnnotationArrayMember.this.owner.ref(value.getDeclaringClass())).p('.').p(value.name());
            }
        };
        this.values.add(annotationValue);
        return this;
    }

    public JAnnotationArrayMember param(JEnumConstant value) {
        JAnnotationStringValue annotationValue = new JAnnotationStringValue(value);
        this.values.add(annotationValue);
        return this;
    }

    public JAnnotationArrayMember param(JExpression value) {
        JAnnotationStringValue annotationValue = new JAnnotationStringValue(value);
        this.values.add(annotationValue);
        return this;
    }

    public JAnnotationArrayMember param(final Class<?> value) {
        JAnnotationStringValue annotationValue = new JAnnotationStringValue(new JExpressionImpl(){

            @Override
            public void generate(JFormatter f) {
                f.p(value.getName().replace('$', '.'));
                f.p(".class");
            }
        });
        this.values.add(annotationValue);
        return this;
    }

    public JAnnotationArrayMember param(JType type) {
        JClass clazz = type.boxify();
        JAnnotationStringValue annotationValue = new JAnnotationStringValue(clazz.dotclass());
        this.values.add(annotationValue);
        return this;
    }

    @Override
    public JAnnotationUse annotate(Class<? extends Annotation> clazz) {
        return this.annotate(this.owner.ref(clazz));
    }

    @Override
    public JAnnotationUse annotate(JClass clazz) {
        JAnnotationUse a = new JAnnotationUse(clazz);
        this.values.add(a);
        return a;
    }

    @Override
    public <W extends JAnnotationWriter> W annotate2(Class<W> clazz) {
        return TypedAnnotationWriter.create(clazz, this);
    }

    @Override
    public Collection<JAnnotationUse> annotations() {
        return Collections.unmodifiableList(this.values);
    }

    public JAnnotationArrayMember param(JAnnotationUse value) {
        this.values.add(value);
        return this;
    }

    @Override
    public void generate(JFormatter f) {
        f.p('{').nl().i();
        boolean first = true;
        for (JAnnotationValue aValue : this.values) {
            if (!first) {
                f.p(',').nl();
            }
            f.g(aValue);
            first = false;
        }
        f.nl().o().p('}');
    }
}

