/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.xml;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Collections;
import java.util.Map;
import java.util.logging.LogRecord;
import javax.xml.transform.stream.StreamSource;
import org.apache.sis.metadata.iso.DefaultMetadata;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.util.logging.WarningListener;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.xml.XML;
import org.opengis.metadata.Metadata;
import org.opengis.referencing.ReferenceSystem;

public class XMLStore
extends DataStore {
    private final String name;
    private StreamSource source;
    private Object object;
    private Metadata metadata;

    public XMLStore(StorageConnector storageConnector) throws DataStoreException {
        Closeable closeable;
        this.name = storageConnector.getStorageName();
        InputStream inputStream = storageConnector.getStorageAs(InputStream.class);
        if (inputStream != null) {
            this.source = new StreamSource(inputStream);
        } else {
            closeable = storageConnector.getStorageAs(Reader.class);
            if (closeable != null) {
                this.source = new StreamSource((Reader)closeable);
            }
        }
        closeable = XMLStore.input(this.source);
        storageConnector.closeAllExcept(closeable);
        if (closeable == null) {
            throw new DataStoreException(Errors.format((short)7, this.name));
        }
    }

    private static Closeable input(StreamSource streamSource) {
        Closeable closeable = null;
        if (streamSource != null && (closeable = streamSource.getInputStream()) == null) {
            closeable = streamSource.getReader();
        }
        return closeable;
    }

    private Map<String, ?> properties() {
        if (this.listeners.hasListeners()) {
            return Collections.singletonMap("org.apache.sis.xml.warningListener", new WarningListener<Object>(){

                @Override
                public Class<Object> getSourceClass() {
                    return Object.class;
                }

                @Override
                public void warningOccured(Object object, LogRecord logRecord) {
                    XMLStore.this.listeners.warning(logRecord);
                }
            });
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unmarshal() throws DataStoreException {
        StreamSource streamSource = this.source;
        Closeable closeable = XMLStore.input(streamSource);
        this.source = null;
        if (closeable != null) {
            try {
                try {
                    this.object = XML.unmarshal(streamSource, this.properties());
                }
                finally {
                    closeable.close();
                }
            }
            catch (Exception exception) {
                throw new DataStoreException(Errors.format((short)9, this.name), exception);
            }
        }
    }

    @Override
    public Metadata getMetadata() throws DataStoreException {
        this.unmarshal();
        if (this.metadata == null) {
            if (this.object instanceof Metadata) {
                this.metadata = (Metadata)this.object;
            } else if (this.object instanceof ReferenceSystem) {
                DefaultMetadata defaultMetadata = new DefaultMetadata();
                defaultMetadata.setReferenceSystemInfo(Collections.singleton((ReferenceSystem)this.object));
                this.metadata = defaultMetadata;
            }
        }
        return this.metadata;
    }

    @Override
    public void close() throws DataStoreException {
        this.object = null;
        Closeable closeable = XMLStore.input(this.source);
        this.source = null;
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                throw new DataStoreException(iOException);
            }
        }
    }
}

