/*
 * Decompiled with CFR 0.152.
 */
package se.softhouse.common.collections;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class CharacterTrie<V>
extends AbstractMap<String, V> {
    private int size = 0;
    private final Entry<V> root = this.createRoot();
    private int modCount = 0;

    @CheckReturnValue
    public static <V> CharacterTrie<V> newTrie() {
        return new CharacterTrie<V>();
    }

    @CheckReturnValue
    public static <V> CharacterTrie<V> newTrie(Map<String, V> map) {
        CharacterTrie<V> trie = CharacterTrie.newTrie();
        trie.putAll(map);
        return trie;
    }

    private CharacterTrie() {
    }

    @Override
    public V put(String key, V value) {
        Objects.requireNonNull(key, "Null key given, CharacterTrie does not support null keys as they are error-prone");
        Objects.requireNonNull(value, "Null value given, CharacterTrie does not support null values as they are error-prone. Use the Null Object Pattern instead.");
        Entry current = this.root;
        int len = key.length();
        for (int i = 0; i < len; ++i) {
            Character c = Character.valueOf(key.charAt(i));
            current = current.ensureChild(c);
        }
        V oldValue = current.setValue(value);
        if (oldValue == null) {
            ++this.size;
            ++this.modCount;
        }
        return oldValue;
    }

    @Override
    @CheckReturnValue
    public int size() {
        return this.size;
    }

    @Override
    public V remove(Object keyToRemove) {
        CharSequence key = (CharSequence)keyToRemove;
        Entry current = this.root;
        int len = key.length();
        for (int i = 0; i < len; ++i) {
            Character c = Character.valueOf(key.charAt(i));
            if ((current = current.getChild(c)) != null) continue;
            return null;
        }
        return this.removeEntry(current);
    }

    private V removeEntry(Entry<V> entryToRemove) {
        V oldValue = entryToRemove.getValue();
        if (((Entry)entryToRemove).unset()) {
            Entry grandParent;
            --this.size;
            ++this.modCount;
            if (((Entry)entryToRemove).hasChildren()) {
                return oldValue;
            }
            Entry parent = ((Entry)entryToRemove).parent;
            parent.deleteChild(((Entry)entryToRemove).index);
            while (!parent.hasChildren() && !parent.isValue && (grandParent = parent.parent) != null) {
                grandParent.deleteChild(parent.index);
                parent = grandParent;
            }
            return oldValue;
        }
        return null;
    }

    @Override
    @CheckReturnValue
    public boolean containsKey(@Nullable Object key) {
        if (key == null) {
            return false;
        }
        String keyToCheckContainMentFor = (String)key;
        return ((Entry)this.root).get(keyToCheckContainMentFor) != null;
    }

    @Override
    @CheckReturnValue
    public V get(Object key) {
        CharSequence keyToFetch = (CharSequence)key;
        return (V)((Entry)this.root).get(keyToFetch);
    }

    @CheckReturnValue
    public Map.Entry<String, V> findLongestPrefix(CharSequence prefix) {
        return ((Entry)this.root).findLongestPrefix(prefix);
    }

    public Set<Map.Entry<String, V>> getEntriesWithPrefix(CharSequence prefix) {
        Entry startingPoint = ((Entry)this.root).findChild(prefix);
        if (startingPoint == null) {
            return Collections.emptySet();
        }
        return new EntrySet(startingPoint);
    }

    private Entry<V> createRoot() {
        return new Entry(Character.valueOf('r'), null);
    }

    @Override
    public void clear() {
        ((Entry)this.root).clear();
        this.size = 0;
        ++this.modCount;
    }

    @Override
    public Set<Map.Entry<String, V>> entrySet() {
        return new EntrySet(this.root);
    }

    private final class EntryIterator
    implements Iterator<Map.Entry<String, V>> {
        private int expectedModCount;
        private Entry<V> next;
        private Entry<V> lastReturned;

        private EntryIterator(Entry<V> startingPoint) {
            this.expectedModCount = CharacterTrie.this.modCount;
            this.lastReturned = null;
            this.next = startingPoint;
        }

        @Override
        public boolean hasNext() {
            if (this.next == null) {
                return false;
            }
            if (this.next == this.lastReturned || this.lastReturned == null) {
                if (this.lastReturned == null) {
                    this.next = this.next.successor(this.lastReturned, "", 0, true);
                } else {
                    String lastKey = this.lastReturned.getKey();
                    int lastDepth = lastKey.length();
                    this.next = this.next.successor(this.lastReturned, lastKey, lastDepth, true);
                }
            }
            return this.next != null;
        }

        @Override
        public Map.Entry<String, V> next() {
            this.verifyUnmodified();
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.next;
            return this.next;
        }

        @Override
        public void remove() {
            this.verifyUnmodified();
            if (this.lastReturned == null) {
                throw new IllegalStateException("You probably forgot to call next before calling remove");
            }
            if (CharacterTrie.this.removeEntry(this.lastReturned) == null) {
                throw new IllegalStateException("You probably forgot to call next before calling remove");
            }
            ++this.expectedModCount;
        }

        private void verifyUnmodified() {
            if (this.expectedModCount != CharacterTrie.this.modCount) {
                throw new ConcurrentModificationException("Trie modified during iteration");
            }
        }
    }

    private final class EntrySet
    extends AbstractSet<Map.Entry<String, V>> {
        private final Entry<V> startingPoint;

        private EntrySet(Entry<V> startingPoint) {
            this.startingPoint = startingPoint;
        }

        @Override
        public Iterator<Map.Entry<String, V>> iterator() {
            return new EntryIterator(this.startingPoint);
        }

        @Override
        public int size() {
            return this.startingPoint.size();
        }

        @Override
        public void clear() {
            CharacterTrie.this.modCount++;
            this.startingPoint.clear();
        }
    }

    private static final class Entry<V>
    implements Map.Entry<String, V> {
        private final Character index;
        private boolean isValue;
        private V value;
        private TreeMap<Character, Entry<V>> children;
        @Nullable
        private final Entry<V> parent;

        private Entry(Character index, @Nullable Entry<V> parent) {
            this.index = index;
            this.parent = parent;
        }

        @Override
        public String getKey() {
            StringBuilder sb = new StringBuilder();
            Entry<V> current = this;
            while (!current.isRoot()) {
                sb.append(current.index);
                current = current.parent;
            }
            return sb.reverse().toString();
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            V oldValue = this.value;
            this.isValue = true;
            this.value = value;
            return oldValue;
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)obj;
            return this.getKey().equals(entry.getKey()) && this.getValue().equals(entry.getValue());
        }

        @Override
        public int hashCode() {
            return this.getKey().hashCode() ^ this.getValue().hashCode();
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }

        private Map.Entry<String, V> findLongestPrefix(CharSequence prefix) {
            Entry<V> child = this.findLastChild(prefix);
            if (child.isValue) {
                return child;
            }
            return null;
        }

        private boolean unset() {
            boolean wasValue = this.isValue;
            this.isValue = false;
            this.value = null;
            return wasValue;
        }

        private boolean isRoot() {
            return this.parent == null;
        }

        private boolean hasChildren() {
            return this.children != null ? this.children.size() > 0 : false;
        }

        private Entry<V> getChild(Character c) {
            return this.children != null ? this.children.get(c) : null;
        }

        private Entry<V> findChild(CharSequence keyToFetch) {
            Character c;
            Entry<V> current = this;
            int len = keyToFetch.length();
            for (int i = 0; i < len && current != null; current = current.getChild(c), ++i) {
                c = Character.valueOf(keyToFetch.charAt(i));
            }
            return current;
        }

        private Entry<V> findLastChild(CharSequence prefix) {
            Entry<V> current = this;
            int len = prefix.length();
            for (int i = 0; i < len; ++i) {
                Character c = Character.valueOf(prefix.charAt(i));
                Entry<V> next = current.getChild(c);
                if (next == null) {
                    return current;
                }
                current = next;
            }
            return current;
        }

        private V get(CharSequence keyToFetch) {
            Entry<V> child = this.findChild(keyToFetch);
            if (child == null) {
                return null;
            }
            if (child.isValue) {
                return child.value;
            }
            return null;
        }

        private void deleteChild(Character c) {
            this.children.remove(c);
        }

        private Entry<V> ensureChild(Character childChar) {
            if (this.children == null) {
                this.children = new TreeMap();
                Entry<V> child = new Entry<V>(childChar, this);
                this.children.put(childChar, child);
                return child;
            }
            Entry<V> existing = this.children.get(childChar);
            if (existing != null) {
                return existing;
            }
            Entry<V> child = new Entry<V>(childChar, this);
            this.children.put(childChar, child);
            return child;
        }

        private void clear() {
            this.children = new TreeMap();
            this.unset();
        }

        private Entry<V> successor(Entry<V> predecessor, CharSequence predecessorKey, int level, boolean isGoingDown) {
            if (this.isValue && predecessor != this && isGoingDown) {
                return this;
            }
            if (this.hasChildren()) {
                Map.Entry<Character, Entry<V>> next = null;
                if (predecessor != null && super.commonDescent(this) && level < predecessorKey.length()) {
                    char charAtLevel = predecessorKey.charAt(level);
                    next = this.children.higherEntry(Character.valueOf(charAtLevel));
                } else {
                    next = this.children.firstEntry();
                }
                if (next != null) {
                    return super.successor(predecessor, predecessorKey, level + 1, true);
                }
            }
            if (!this.isRoot()) {
                return super.successor(predecessor, predecessorKey, level - 1, false);
            }
            return null;
        }

        private boolean ancestorFor(Entry<V> entry) {
            if (this.isRoot()) {
                return true;
            }
            Entry<V> entryAncestor = entry.parent;
            while (entryAncestor != null && this != entryAncestor) {
                entryAncestor = entryAncestor.parent;
            }
            return this == entryAncestor;
        }

        private boolean commonDescent(Entry<V> entry) {
            if (this.ancestorFor(entry)) {
                return true;
            }
            return super.ancestorFor(this);
        }

        private int size() {
            int size;
            int n = size = this.isValue ? 1 : 0;
            if (this.hasChildren()) {
                for (Entry<V> child : this.children.values()) {
                    size += super.size();
                }
            }
            return size;
        }
    }
}

