/*
 * Decompiled with CFR 0.152.
 */
package se.softhouse.common.guavaextensions;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public final class Lists2 {
    private Lists2() {
    }

    public static <E> ArrayList<E> newArrayList(Iterable<? extends E> elements) {
        Objects.requireNonNull(elements);
        return elements instanceof Collection ? new ArrayList<E>(Lists2.cast(elements)) : Lists2.newArrayList(elements.iterator());
    }

    public static <E> ArrayList<E> newArrayList(Iterator<? extends E> elements) {
        ArrayList list = new ArrayList();
        elements.forEachRemaining(e -> list.add(e));
        return list;
    }

    public static <E> ArrayList<E> asList(E firstElement, E[] rest) {
        ArrayList<E> objects = new ArrayList<E>();
        objects.add(firstElement);
        objects.addAll(Arrays.asList(rest));
        return objects;
    }

    public static boolean isEmpty(Iterable<?> iterable) {
        if (iterable instanceof Collection) {
            return ((Collection)iterable).isEmpty();
        }
        return !iterable.iterator().hasNext();
    }

    public static List<Character> charactersOf(CharSequence sequence) {
        return new CharSequenceAsList(Objects.requireNonNull(sequence));
    }

    public static int size(Iterator<?> iterator) {
        int i = 0;
        while (iterator.hasNext()) {
            ++i;
            iterator.next();
        }
        return i;
    }

    public static int size(Iterable<?> iterable) {
        if (iterable instanceof Collection) {
            return ((Collection)iterable).size();
        }
        return Lists2.size(iterable.iterator());
    }

    public static <T> Iterator<T> unmodifiableIterator(final Iterator<? extends T> iterator) {
        Objects.requireNonNull(iterator);
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public T next() {
                return iterator.next();
            }
        };
    }

    static <T> Collection<T> cast(Iterable<T> iterable) {
        return (Collection)iterable;
    }

    private static final class CharSequenceAsList
    extends AbstractList<Character> {
        private final CharSequence sequence;

        CharSequenceAsList(CharSequence sequence) {
            this.sequence = sequence;
        }

        @Override
        public Character get(int index) {
            return Character.valueOf(this.sequence.charAt(index));
        }

        @Override
        public int size() {
            return this.sequence.length();
        }
    }
}

