/*
 * Decompiled with CFR 0.152.
 */
package se.softhouse.common.guavaextensions;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class Preconditions2 {
    private Preconditions2() {
    }

    public static void check(boolean expression, @Nullable String errorMessage, Object ... args) {
        if (!expression) {
            throw new IllegalArgumentException(String.format(errorMessage, args));
        }
    }

    @Nonnull
    public static <T> List<T> checkNulls(Iterable<T> items, String message) {
        Objects.requireNonNull(message, "a message describing what it is that is containing the elements must be given");
        ArrayList<T> nullCheckedList = new ArrayList<T>();
        int index = 0;
        for (T element : items) {
            if (element == null) {
                throw new NullPointerException(message + " (discovered one at index " + index + ")");
            }
            nullCheckedList.add(element);
            ++index;
        }
        return nullCheckedList;
    }
}

