/*
 * Decompiled with CFR 0.152.
 */
package se.softhouse.common.guavaextensions;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import se.softhouse.common.strings.Describables;

@Immutable
public final class Predicates2 {
    private Predicates2() {
    }

    public static <T> Predicate<T> alwaysTrue() {
        return ObjectPredicates.ALWAYS_TRUE.withNarrowedType();
    }

    public static <T> Predicate<T> alwaysFalse() {
        return ObjectPredicates.ALWAYS_FALSE.withNarrowedType();
    }

    public static <E> Predicate<List<? extends E>> listPredicate(Predicate<E> elementLimiter) {
        Objects.requireNonNull(elementLimiter);
        if (elementLimiter == Predicates2.alwaysTrue()) {
            return Predicates2.alwaysTrue();
        }
        return new ListPredicate(elementLimiter);
    }

    public static <T> Predicate<? super T> and(final Predicate<? super T> first, final Predicate<? super T> second) {
        Objects.requireNonNull(first);
        Objects.requireNonNull(second);
        if (first == Predicates2.alwaysTrue()) {
            return second;
        }
        if (second == Predicates2.alwaysTrue()) {
            return first;
        }
        return new Predicate<T>(){

            @Override
            public boolean test(T o) {
                return first.test(o) && second.test(o);
            }

            public String toString() {
                return "AND(" + first + ", " + second + ")";
            }
        };
    }

    public static <T> Predicate<T> in(Collection<? extends T> target) {
        Objects.requireNonNull(target);
        return e -> target.contains(e);
    }

    private static final class ListPredicate<E>
    implements Predicate<List<? extends E>> {
        private final Predicate<E> elementLimiter;

        private ListPredicate(Predicate<E> elementLimiter) {
            this.elementLimiter = elementLimiter;
        }

        @Override
        public boolean test(@Nonnull List<? extends E> values) {
            for (E value : values) {
                if (this.elementLimiter.test(value)) continue;
                throw Describables.illegalArgument(Describables.format("'%s' is not %s", value, this.elementLimiter));
            }
            return true;
        }

        public String toString() {
            return this.elementLimiter.toString();
        }
    }

    private static enum ObjectPredicates implements Predicate
    {
        ALWAYS_TRUE(i -> true),
        ALWAYS_FALSE(i -> false),
        IS_NULL(i -> i == null),
        NOT_NULL(i -> i != null);

        private Predicate<Object> predicate;

        private ObjectPredicates(Predicate<Object> predicate) {
            this.predicate = predicate;
        }

        public boolean test(Object o) {
            return this.predicate.test(o);
        }

        <T> Predicate<T> withNarrowedType() {
            return this;
        }
    }
}

