/*
 * Decompiled with CFR 0.152.
 */
package se.softhouse.common.strings;

import java.io.File;
import java.text.NumberFormat;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import se.softhouse.common.guavaextensions.Preconditions2;
import se.softhouse.common.strings.Describer;
import se.softhouse.common.strings.StringBuilders;
import se.softhouse.common.strings.StringsUtil;

@Immutable
public final class Describers {
    private static final String NULL = "null";

    private Describers() {
    }

    @Nonnull
    @CheckReturnValue
    public static <T> Describer<T> withConstantString(String constant) {
        Objects.requireNonNull(constant);
        return (value, locale) -> constant;
    }

    @Nonnull
    @CheckReturnValue
    public static <T> Describer<T> toStringDescriber() {
        return (value, locale) -> String.valueOf(value);
    }

    @Nonnull
    @CheckReturnValue
    public static Describer<Character> characterDescriber() {
        return CharDescriber.INSTANCE;
    }

    @Nonnull
    @CheckReturnValue
    public static Describer<File> fileDescriber() {
        return FileDescriber.INSTANCE;
    }

    @Nonnull
    @CheckReturnValue
    public static Describer<Boolean> booleanAsEnabledDisabled() {
        return BooleanDescribers.ENABLED_DISABLED;
    }

    @Nonnull
    @CheckReturnValue
    public static Describer<Boolean> booleanAsOnOff() {
        return BooleanDescribers.ON_OFF;
    }

    public static Describer<Number> numberDescriber() {
        return NumberDescriber.INSTANCE;
    }

    @Nonnull
    @CheckReturnValue
    public static <K, V> Describer<Map<K, V>> mapDescriber(Map<K, String> descriptions) {
        return new MapDescription(Collections.unmodifiableMap(descriptions), Describers.toStringDescriber());
    }

    public static <K, V> Describer<Map<K, V>> mapDescriber(Map<K, String> descriptions, Describer<K> keyDescriber) {
        return new MapDescription(Collections.unmodifiableMap(descriptions), Objects.requireNonNull(keyDescriber));
    }

    @CheckReturnValue
    @Nonnull
    public static <K, V> Describer<Map<K, V>> mapDescriber(Describer<V> valueDescriber) {
        return new MapDescriber(Describers.toStringDescriber(), valueDescriber, "=");
    }

    @CheckReturnValue
    @Nonnull
    public static <K, V> Describer<Map<K, V>> mapDescriber(Describer<V> valueDescriber, String valueSeparator) {
        return new MapDescriber(Describers.toStringDescriber(), valueDescriber, valueSeparator);
    }

    @CheckReturnValue
    @Nonnull
    public static <K, V> Describer<Map<K, V>> mapDescriber(Describer<K> keyDescriber, Describer<V> valueDescriber) {
        return new MapDescriber(keyDescriber, valueDescriber, "=");
    }

    @CheckReturnValue
    @Nonnull
    public static <K, V> Describer<Map<K, V>> mapDescriber(Describer<K> keyDescriber, Describer<V> valueDescriber, String valueSeparator) {
        return new MapDescriber(keyDescriber, valueDescriber, valueSeparator);
    }

    @Nonnull
    @CheckReturnValue
    public static <T> Function<? super T, String> asFunction(Describer<T> describer, Locale locale) {
        Objects.requireNonNull(describer);
        Objects.requireNonNull(locale);
        return input -> describer.describe(input, locale);
    }

    @Nonnull
    @CheckReturnValue
    public static <T> Describer<T> usingFunction(Function<T, String> describerFunction) {
        Objects.requireNonNull(describerFunction);
        return (value, inLocale) -> (String)describerFunction.apply(value);
    }

    @Nonnull
    @CheckReturnValue
    public static <T> Describer<List<? extends T>> listDescriber(Describer<T> valueDescriber) {
        return new ListDescriber<T>(valueDescriber, ", ");
    }

    @Nonnull
    @CheckReturnValue
    public static <T> Describer<List<? extends T>> listDescriber(Describer<T> valueDescriber, String valueSeparator) {
        return new ListDescriber<T>(valueDescriber, valueSeparator);
    }

    private static final class ListDescriber<T>
    implements Describer<List<? extends T>> {
        private final Describer<T> valueDescriber;
        private final String valueSeparator;

        ListDescriber(Describer<T> valueDescriber, String valueSeparator) {
            this.valueDescriber = Objects.requireNonNull(valueDescriber);
            this.valueSeparator = Objects.requireNonNull(valueSeparator);
        }

        @Override
        public String describe(List<? extends T> value, Locale inLocale) {
            if (value == null) {
                return Describers.NULL;
            }
            if (value.isEmpty()) {
                return "Empty list";
            }
            Iterator<T> values = value.iterator();
            String firstValue = this.valueDescriber.describe(values.next(), inLocale);
            StringBuilder sb = StringBuilders.withExpectedSize(value.size() * firstValue.length());
            sb.append(firstValue);
            while (values.hasNext()) {
                sb.append(this.valueSeparator).append(this.valueDescriber.describe(values.next(), inLocale));
            }
            return sb.toString();
        }
    }

    private static final class MapDescriber<K, V>
    implements Describer<Map<K, V>> {
        private final Describer<V> valueDescriber;
        private final Describer<K> keyDescriber;
        private final String valueSeparator;

        private MapDescriber(Describer<K> keyDescriber, Describer<V> valueDescriber, String valueSeparator) {
            this.keyDescriber = Objects.requireNonNull(keyDescriber);
            this.valueDescriber = Objects.requireNonNull(valueDescriber);
            this.valueSeparator = Objects.requireNonNull(valueSeparator);
        }

        @Override
        public String describe(Map<K, V> values, Locale inLocale) {
            if (values == null) {
                return Describers.NULL;
            }
            Iterator<Map.Entry<K, V>> iterator = values.entrySet().iterator();
            if (!iterator.hasNext()) {
                return "Empty map";
            }
            StringBuilder firstKeyValue = new StringBuilder();
            this.describeEntry(iterator.next(), inLocale, firstKeyValue);
            StringBuilder result = StringBuilders.withExpectedSize(firstKeyValue.length() * values.size());
            result.append((CharSequence)firstKeyValue);
            while (iterator.hasNext()) {
                result.append(StringsUtil.NEWLINE);
                this.describeEntry(iterator.next(), inLocale, result);
            }
            return result.toString();
        }

        private void describeEntry(Map.Entry<K, V> entry, Locale inLocale, StringBuilder output) {
            output.append(this.keyDescriber.describe(entry.getKey(), inLocale));
            output.append(this.valueSeparator);
            output.append(this.valueDescriber.describe(entry.getValue(), inLocale));
        }
    }

    private static final class MapDescription<K, V>
    implements Describer<Map<K, V>> {
        private final Map<K, String> descriptions;
        private final Describer<K> keyDescriber;

        private MapDescription(Map<K, String> descriptions, Describer<K> keyDescriber) {
            this.descriptions = descriptions;
            this.keyDescriber = keyDescriber;
        }

        @Override
        public String describe(Map<K, V> values, Locale inLocale) {
            StringBuilder result = new StringBuilder();
            for (Map.Entry<K, V> entry : values.entrySet()) {
                K key = entry.getKey();
                result.append(this.keyDescriber.describe(key, inLocale));
                result.append("=");
                result.append(entry.getValue());
                String descriptionForEntry = this.descriptions.get(key);
                Preconditions2.check(descriptionForEntry != null, "Undescribed key: %s", key);
                result.append(StringsUtil.NEWLINE).append(" ").append(descriptionForEntry).append(StringsUtil.NEWLINE);
            }
            return result.toString();
        }
    }

    private static final class NumberDescriber
    implements Describer<Number> {
        private static final Describer<Number> INSTANCE = new NumberDescriber();

        private NumberDescriber() {
        }

        @Override
        public String describe(Number number, Locale locale) {
            if (number == null) {
                return Describers.NULL;
            }
            return NumberFormat.getInstance(locale).format(number);
        }

        public String toString() {
            return "NumberDescriber";
        }
    }

    static enum BooleanDescribers implements Describer<Boolean>
    {
        ENABLED_DISABLED{

            @Override
            public String describe(Boolean value, Locale inLocale) {
                return value != false ? "enabled" : "disabled";
            }
        }
        ,
        ON_OFF{

            @Override
            public String describe(Boolean value, Locale inLocale) {
                return value != false ? "on" : "off";
            }
        };

    }

    private static final class FileDescriber
    implements Describer<File> {
        private static final Describer<File> INSTANCE = new FileDescriber();

        private FileDescriber() {
        }

        @Override
        public String describe(File file, Locale inLocale) {
            if (file == null) {
                return Describers.NULL;
            }
            return file.getAbsolutePath();
        }
    }

    private static final class CharDescriber
    implements Describer<Character> {
        private static final Describer<Character> INSTANCE = new CharDescriber();

        private CharDescriber() {
        }

        @Override
        public String describe(Character value, Locale inLocale) {
            if (value == null) {
                return Describers.NULL;
            }
            return value.charValue() == '\u0000' ? "the Null character" : value.toString();
        }
    }
}

