/*
 * Decompiled with CFR 0.152.
 */
package se.softhouse.common.strings;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import se.softhouse.common.guavaextensions.Lists2;
import se.softhouse.common.guavaextensions.Preconditions2;

@Immutable
public final class StringsUtil {
    public static final String NEWLINE = System.getProperty("line.separator");
    public static final Charset UTF8 = Charset.forName("UTF-8");
    public static final char TAB = '\t';

    private StringsUtil() {
    }

    @Nonnull
    @CheckReturnValue
    @Deprecated
    public static String spaces(int numberOfSpaces) {
        return StringsUtil.repeat(" ", numberOfSpaces);
    }

    public static String pointingAtIndex(int indexToPointAt) {
        return StringsUtil.spaces(indexToPointAt) + "^";
    }

    public static boolean startsWithAndHasMore(String input, String toStartWith) {
        return input.startsWith(toStartWith) && input.length() > toStartWith.length();
    }

    @Nonnull
    @CheckReturnValue
    public static String closestMatch(String input, Iterable<String> validOptions) {
        Objects.requireNonNull(input);
        Preconditions2.check(!Lists2.isEmpty(validOptions), "No valid options to match the input against", new Object[0]);
        int shortestDistance = Integer.MAX_VALUE;
        String bestGuess = null;
        for (String validOption : validOptions) {
            int distance = StringsUtil.levenshteinDistance(input, validOption);
            if (distance >= shortestDistance) continue;
            shortestDistance = distance;
            bestGuess = validOption;
        }
        return bestGuess;
    }

    @Nonnull
    @CheckReturnValue
    public static List<String> closestMatches(String input, Iterable<String> validOptions, int maximumDistance) {
        Objects.requireNonNull(input);
        if (Lists2.isEmpty(validOptions)) {
            return Collections.emptyList();
        }
        ArrayList<CloseMatch> closeMatches = new ArrayList<CloseMatch>();
        for (String validOption : validOptions) {
            int distance = StringsUtil.levenshteinDistance(input, validOption, maximumDistance + 1);
            if (distance > maximumDistance) continue;
            closeMatches.add(new CloseMatch(validOption, distance));
        }
        return closeMatches.stream().sorted((l, r) -> ((CloseMatch)l).measuredDistance - ((CloseMatch)r).measuredDistance).map(i -> ((CloseMatch)i).value).collect(Collectors.toList());
    }

    public static int levenshteinDistance(String left, String right) {
        return StringsUtil.levenshteinDistance(left, right, Integer.MAX_VALUE);
    }

    public static int levenshteinDistance(String left, String right, int maxDistance) {
        int leftIndex;
        Objects.requireNonNull(left);
        Objects.requireNonNull(right);
        Preconditions2.check(maxDistance >= 0, "only zero or positive distance supported. Not ", maxDistance);
        int leftLength = left.length();
        int rightLength = right.length();
        if (leftLength == 0) {
            return rightLength;
        }
        if (rightLength == 0) {
            return leftLength;
        }
        if (Math.abs(leftLength - rightLength) > maxDistance) {
            return maxDistance;
        }
        int[] previousDistances = new int[leftLength + 1];
        int[] distances = new int[leftLength + 1];
        for (leftIndex = 0; leftIndex <= leftLength; ++leftIndex) {
            previousDistances[leftIndex] = leftIndex;
        }
        for (int rightIndex = 1; rightIndex <= rightLength; ++rightIndex) {
            char rightChar = right.charAt(rightIndex - 1);
            distances[0] = rightIndex;
            for (leftIndex = 1; leftIndex <= leftLength; ++leftIndex) {
                int insertionCost = distances[leftIndex - 1] + 1;
                int editCost = previousDistances[leftIndex] + 1;
                int deletionCost = previousDistances[leftIndex - 1];
                if (left.charAt(leftIndex - 1) != rightChar) {
                    // empty if block
                }
                distances[leftIndex] = IntStream.of(insertionCost, editCost, ++deletionCost).min().getAsInt();
            }
            int[] temp = previousDistances;
            previousDistances = distances;
            distances = temp;
        }
        return previousDistances[leftLength];
    }

    @Nonnull
    @CheckReturnValue
    public static String numberToPositionalString(int number) {
        Preconditions2.check(number >= 0, "Negative numbers don't have positions", new Object[0]);
        switch (number) {
            case 0: {
                return "zeroth";
            }
            case 1: {
                return "first";
            }
            case 2: {
                return "second";
            }
            case 3: {
                return "third";
            }
            case 4: {
                return "fourth";
            }
            case 5: {
                return "fifth";
            }
        }
        return Integer.toString(number) + "th";
    }

    public static int indexOfNth(int nth, String needle, String haystack) {
        Objects.requireNonNull(haystack);
        Objects.requireNonNull(needle);
        Preconditions2.check(nth > 0, "nth must be at least 1 (was %s)", nth);
        int index = -1;
        for (int occurencesFound = 0; occurencesFound < nth; ++occurencesFound) {
            index = haystack.indexOf(needle, index + 1);
            if (index != -1) continue;
            break;
        }
        return index;
    }

    @Nonnull
    @CheckReturnValue
    public static String repeat(String part, int times) {
        Preconditions2.check(times >= 0, "Negative repitions is not supported. Was: ", times);
        StringBuilder builder = new StringBuilder(part.length() * times);
        for (int i = 0; i < times; ++i) {
            builder.append(part);
        }
        return builder.toString();
    }

    static final class CloseMatch {
        private final int measuredDistance;
        private final String value;

        private CloseMatch(String validOption, int distance) {
            this.measuredDistance = distance;
            this.value = validOption;
        }
    }
}

