/*
 * Decompiled with CFR 0.152.
 */
package se.softhouse.jargo;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import se.softhouse.common.guavaextensions.Suppliers2;
import se.softhouse.common.strings.Describable;
import se.softhouse.jargo.Argument;
import se.softhouse.jargo.ArgumentException;
import se.softhouse.jargo.CommandLineParser;
import se.softhouse.jargo.CommandLineParserInstance;
import se.softhouse.jargo.ParsedArguments;
import se.softhouse.jargo.ProgramInformation;
import se.softhouse.jargo.StringParsers;

@Immutable
public abstract class Command
extends StringParsers.InternalStringParser<ParsedArguments>
implements Describable {
    @Nonnull
    private final List<Argument<?>> commandArguments;
    @Nonnull
    private final Supplier<CommandLineParserInstance> commandArgumentParser = Suppliers2.memoize(new Supplier<CommandLineParserInstance>(){

        @Override
        public CommandLineParserInstance get() {
            return new CommandLineParserInstance(Command.this.commandArguments, ProgramInformation.AUTO, CommandLineParser.US_BY_DEFAULT, true);
        }
    });

    protected Command(Argument<?> ... commandArguments) {
        this.commandArguments = Collections.unmodifiableList(Arrays.asList(commandArguments));
    }

    @Nonnull
    @CheckReturnValue
    protected String commandName() {
        return this.getClass().getSimpleName().toLowerCase(Locale.US);
    }

    protected abstract void execute(ParsedArguments var1);

    @Override
    @Nonnull
    public String description() {
        return "";
    }

    public String toString() {
        return this.commandName();
    }

    @Override
    final ParsedArguments parse(CommandLineParserInstance.ArgumentIterator arguments, ParsedArguments previousOccurance, Argument<?> argumentSettings, Locale locale) throws ArgumentException {
        arguments.rememberAsCommand();
        ParsedArguments parsedArguments = this.parser().parse(arguments, locale);
        arguments.rememberInvocationOfCommand(this, parsedArguments);
        return parsedArguments;
    }

    private CommandLineParserInstance parser() {
        return this.commandArgumentParser.get();
    }

    @Override
    final ParsedArguments defaultValue() {
        return null;
    }

    @Override
    final String descriptionOfValidValues(Argument<?> argumentSettings, Locale locale) {
        return this.parser().usage(locale).toString();
    }

    @Override
    final String describeValue(ParsedArguments value) {
        return null;
    }

    @Override
    final String metaDescription(Argument<?> argumentSettings) {
        return "";
    }

    @Override
    String metaDescriptionInRightColumn(Argument<?> argumentSettings) {
        return "Arguments";
    }
}

