/*
 * Decompiled with CFR 0.152.
 */
package se.softhouse.jargo;

import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.concurrent.NotThreadSafe;
import se.softhouse.common.strings.Lines;
import se.softhouse.common.strings.StringBuilders;
import se.softhouse.common.strings.StringsUtil;
import se.softhouse.jargo.Argument;
import se.softhouse.jargo.CommandLineParserInstance;
import se.softhouse.jargo.ProgramInformation;

@NotThreadSafe
public final class Usage
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final transient Collection<Argument<?>> unfilteredArguments;
    private transient String errorMessage = "";
    private final transient Locale locale;
    private final transient ProgramInformation program;
    private final transient boolean forCommand;
    private transient int columnWidth = 80;
    private transient String fromSerializedUsage = null;
    private transient int indexOfDescriptionColumn;
    private transient List<Argument<?>> argumentsToPrint;
    private static final int SPACES_BETWEEN_COLUMNS = 4;
    private static final Pattern BY_NEWLINE = Pattern.compile(StringsUtil.NEWLINE);

    Usage(Collection<Argument<?>> arguments, Locale locale, ProgramInformation program, boolean forCommand) {
        this.unfilteredArguments = arguments;
        this.locale = locale;
        this.program = program;
        this.forCommand = forCommand;
    }

    Usage(CommandLineParserInstance parser) {
        this.unfilteredArguments = parser.allArguments();
        this.locale = parser.locale();
        this.program = parser.programInformation();
        this.forCommand = parser.isCommandParser();
    }

    private Usage(String fromSerializedUsage) {
        this(null, null, null, false);
        this.fromSerializedUsage = fromSerializedUsage;
    }

    Usage withErrorMessage(String message) {
        this.errorMessage = Objects.requireNonNull(message);
        return this;
    }

    public String toString() {
        return this.usage();
    }

    private String usage() {
        if (this.fromSerializedUsage != null) {
            return this.fromSerializedUsage;
        }
        this.init();
        StringBuilder builder = this.newStringBuilder();
        this.printOn(builder);
        return builder.toString();
    }

    public void printOn(Appendable target) throws IOException {
        if (this.fromSerializedUsage != null) {
            target.append(this.fromSerializedUsage);
        } else {
            this.init();
            this.appendUsageTo(target);
        }
    }

    public void printOn(PrintStream target) {
        try {
            this.printOn((Appendable)target);
        }
        catch (IOException impossible) {
            throw new AssertionError((Object)impossible);
        }
    }

    public void printOn(StringBuilder target) {
        try {
            this.printOn((Appendable)target);
        }
        catch (IOException impossible) {
            throw new AssertionError((Object)impossible);
        }
    }

    private void appendUsageTo(Appendable builder) throws IOException {
        builder.append(this.errorMessage);
        builder.append(this.header());
        for (Argument<?> arg : this.argumentsToPrint) {
            Row forArgument = this.usageForArgument(arg);
            this.appendRowTo(forArgument, builder);
        }
    }

    private String header() {
        if (this.forCommand) {
            return this.hasArguments() ? StringsUtil.NEWLINE : "";
        }
        String mainUsage = "Usage: " + this.program.programName();
        if (this.hasArguments()) {
            mainUsage = mainUsage + " [Arguments]";
        }
        mainUsage = mainUsage + StringsUtil.NEWLINE + Lines.wrap(this.program.programDescription(), this.columnWidth, this.locale);
        if (this.hasArguments()) {
            mainUsage = mainUsage + StringsUtil.NEWLINE + "Arguments" + ":" + StringsUtil.NEWLINE;
        }
        return mainUsage;
    }

    private void init() {
        if (this.argumentsToPrint == null) {
            this.argumentsToPrint = this.sortedArguments();
            this.indexOfDescriptionColumn = this.determineLongestNameColumn() + 4;
        }
    }

    private List<Argument<?>> sortedArguments() {
        Stream<Argument<?>> indexedWithoutVariableArity = this.unfilteredArguments.stream().filter(Argument.IS_VISIBLE.and(Argument.IS_INDEXED).and(Argument.IS_OF_VARIABLE_ARITY.negate()));
        Stream<Argument<?>> indexedWithVariableArity = this.unfilteredArguments.stream().filter(Argument.IS_VISIBLE.and(Argument.IS_INDEXED).and(Argument.IS_OF_VARIABLE_ARITY));
        Stream<Argument<?>> sortedArgumentsByName = this.unfilteredArguments.stream().filter(Argument.IS_VISIBLE.and(Argument.IS_INDEXED.negate())).sorted(Argument.NAME_COMPARATOR);
        Stream result = Stream.of(indexedWithoutVariableArity, sortedArgumentsByName, indexedWithVariableArity).flatMap(x -> x);
        return Collections.unmodifiableList(result.collect(Collectors.toList()));
    }

    private int determineLongestNameColumn() {
        int longestNameSoFar = 0;
        for (Argument<?> arg : this.argumentsToPrint) {
            longestNameSoFar = Math.max(longestNameSoFar, this.lengthOfNameColumn(arg));
        }
        return Math.min(longestNameSoFar, this.maxNameColumnWidth());
    }

    private int lengthOfNameColumn(Argument<?> argument) {
        int namesLength = 0;
        for (String name : argument.names()) {
            namesLength += name.length();
        }
        int separatorLength = Math.max(0, ", ".length() * (argument.names().size() - 1));
        int metaLength = argument.metaDescriptionInLeftColumn().length();
        return namesLength + separatorLength + metaLength;
    }

    private int maxNameColumnWidth() {
        return this.columnWidth / 3 * 2;
    }

    private StringBuilder newStringBuilder() {
        return StringBuilders.withExpectedSize(2 * this.argumentsToPrint.size() * this.columnWidth);
    }

    private boolean hasArguments() {
        return !this.argumentsToPrint.isEmpty();
    }

    private Row usageForArgument(Argument<?> arg) {
        Row row = new Row();
        row.nameColumn.append(String.join((CharSequence)", ", arg.names()));
        row.nameColumn.append(arg.metaDescriptionInLeftColumn());
        String description = arg.description();
        if (!description.isEmpty()) {
            row.descriptionColumn.append((CharSequence)Lines.wrap(description, this.indexOfDescriptionColumn, this.columnWidth, this.locale));
            this.addIndicators(arg, row.descriptionColumn);
            row.descriptionColumn.append(StringsUtil.NEWLINE);
            this.valueExplanation(arg, row.descriptionColumn);
        } else {
            this.valueExplanation(arg, row.descriptionColumn);
            this.addIndicators(arg, row.descriptionColumn);
        }
        return row;
    }

    private <T> void addIndicators(Argument<T> arg, StringBuilder target) {
        if (arg.isRequired()) {
            target.append(" [Required]");
        }
        if (arg.isAllowedToRepeat()) {
            target.append(" [Supports Multiple occurrences]");
        }
    }

    private <T> void valueExplanation(Argument<T> arg, StringBuilder target) {
        String validValuesDescription = arg.descriptionOfValidValues(this.locale);
        if (!validValuesDescription.isEmpty()) {
            String meta = arg.metaDescriptionInRightColumn();
            target.append(meta + ": ").append(validValuesDescription);
        }
        if (arg.isRequired()) {
            return;
        }
        String descriptionOfDefaultValue = arg.defaultValueDescription(this.locale);
        if (descriptionOfDefaultValue != null) {
            if (!validValuesDescription.isEmpty()) {
                target.append(StringsUtil.NEWLINE);
            }
            String spaces = StringsUtil.repeat(" ", "Default: ".length());
            descriptionOfDefaultValue = descriptionOfDefaultValue.replace(StringsUtil.NEWLINE, StringsUtil.NEWLINE + spaces);
            target.append("Default: ").append(descriptionOfDefaultValue);
        }
    }

    private void appendRowTo(Row row, Appendable target) throws IOException {
        StringBuilder nameColumn = Lines.wrap(row.nameColumn, this.indexOfDescriptionColumn, this.locale);
        String descriptionColumn = row.descriptionColumn.toString();
        String[] nameLines = BY_NEWLINE.split(nameColumn);
        Iterator descriptionLines = BY_NEWLINE.splitAsStream(descriptionColumn).iterator();
        for (String nameLine : nameLines) {
            target.append(nameLine);
            if (descriptionLines.hasNext()) {
                int lengthOfNameColumn = nameLine.length();
                int paddingWidth = Math.max(1, this.indexOfDescriptionColumn - lengthOfNameColumn);
                target.append(StringsUtil.repeat(" ", paddingWidth));
                target.append((CharSequence)descriptionLines.next());
            }
            target.append(StringsUtil.NEWLINE);
        }
        while (descriptionLines.hasNext()) {
            target.append(StringsUtil.repeat(" ", this.indexOfDescriptionColumn));
            target.append((CharSequence)descriptionLines.next());
            target.append(StringsUtil.NEWLINE);
        }
    }

    private Object writeReplace() {
        return new SerializationProxy(this);
    }

    private static final class SerializationProxy
    implements Serializable {
        private final String serializedUsage;
        private static final long serialVersionUID = 1L;

        private SerializationProxy(Usage usage) {
            this.serializedUsage = usage.usage();
        }

        private Object readResolve() {
            return new Usage(this.serializedUsage);
        }
    }

    static final class Row {
        private final StringBuilder nameColumn = new StringBuilder();
        private final StringBuilder descriptionColumn = new StringBuilder();

        Row() {
        }

        public String toString() {
            return this.nameColumn.toString() + " " + this.descriptionColumn.toString();
        }
    }
}

