/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.http;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.FilterConfig;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;

public class ApplicationConfig {
    final FilterConfig config;
    final ServletConfig servletConfig;
    final ServletContext servletContext;
    final List<String> parameterNames = new ArrayList<String>();

    public ApplicationConfig() {
        this.config = null;
        this.servletConfig = null;
        this.servletContext = null;
    }

    public ApplicationConfig(FilterConfig config) {
        this.config = config;
        this.servletConfig = null;
        this.servletContext = config.getServletContext();
        if (config == null) {
            return;
        }
        Enumeration en = config.getInitParameterNames();
        while (en.hasMoreElements()) {
            this.parameterNames.add((String)en.nextElement());
        }
    }

    public ApplicationConfig(ServletConfig config) {
        this.config = null;
        this.servletConfig = config;
        this.servletContext = this.servletConfig.getServletContext();
        if (config == null) {
            return;
        }
        Enumeration en = config.getInitParameterNames();
        while (en.hasMoreElements()) {
            this.parameterNames.add((String)en.nextElement());
        }
    }

    public String getFilterName() {
        if (this.servletConfig != null) {
            return this.servletConfig.getServletName();
        }
        return this.config.getFilterName();
    }

    public String getContextName() {
        return this.servletContext.getServletContextName();
    }

    public String getInitParameter(String string) {
        if (this.servletConfig != null) {
            return this.servletConfig.getInitParameter(string);
        }
        return this.config.getInitParameter(string);
    }

    public Collection<String> getInitParameterNames() {
        return this.parameterNames;
    }

    public File getConfigFile(String path) {
        File f = new File(this.getWebInfDir(), path);
        return f;
    }

    public File getWebInfDir() {
        String s = this.servletContext.getRealPath("WEB-INF/");
        File f = new File(s);
        return f;
    }

    public File getRootFolder() {
        String s = this.servletContext.getRealPath("/");
        File f = new File(s);
        return f;
    }

    public File mapPath(String url) {
        String pth = this.servletContext.getRealPath(url);
        File file = new File(pth);
        return file;
    }
}

