/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.http;

import com.bradmcevoy.http.MiltonServlet;
import com.bradmcevoy.http.Resource;
import com.bradmcevoy.http.ResourceFactory;
import com.bradmcevoy.http.ServletResource;
import java.io.File;
import javax.servlet.ServletContext;
import org.springframework.beans.factory.annotation.Autowired;

public class ServletResourceFactory
implements ResourceFactory {
    private final ServletContext servletContext;

    @Autowired
    public ServletResourceFactory(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public Resource getResource(String host, String path) {
        String contextPath = MiltonServlet.request().getContextPath();
        String localPath = path.substring(contextPath.length());
        String realPath = this.servletContext.getRealPath(localPath);
        if (realPath != null) {
            File file = new File(realPath);
            if (file.exists() && !file.isDirectory()) {
                return new ServletResource(file, localPath, MiltonServlet.request(), MiltonServlet.response());
            }
            return null;
        }
        return null;
    }
}

