/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.http;

import com.ettrema.sso.SsoSessionProvider;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;

public class ServletSsoSessionProvider
implements SsoSessionProvider,
HttpSessionListener {
    private static final Map<String, HttpSession> mapOfSessions = new ConcurrentHashMap<String, HttpSession>();
    private String userSessionVariableName = "user";

    public Object getUserTag(String firstComp) {
        HttpSession sess = mapOfSessions.get(firstComp);
        if (sess == null) {
            return null;
        }
        Object oUser = sess.getAttribute(this.userSessionVariableName);
        return oUser;
    }

    public void sessionCreated(HttpSessionEvent hse) {
        String id = hse.getSession().getId();
        mapOfSessions.put(id, hse.getSession());
    }

    public void sessionDestroyed(HttpSessionEvent hse) {
        String id = hse.getSession().getId();
        mapOfSessions.remove(id);
    }

    public String getUserSessionVariableName() {
        return this.userSessionVariableName;
    }

    public void setUserSessionVariableName(String userSessionVariableName) {
        this.userSessionVariableName = userSessionVariableName;
    }
}

