/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.utils.build;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.jar.JarFile;
import org.apache.uima.pear.tools.InstallationController;
import org.apache.uima.pear.tools.InstallationDescriptor;
import org.apache.uima.pear.tools.InstallationDescriptorHandler;
import org.apache.uima.pear.tools.PackageBrowser;
import org.apache.uima.pear.util.MessageRouter;
import org.apache.uima.tools.cvd.CVD;
import org.apache.uima.tools.cvd.MainFrame;

public class InstallPearSilently {
    private static File localTearFile = null;
    private static File installationDir = null;
    private static String mainComponentId;
    private static InstallationDescriptor insdObject;
    private static String mainComponentRootPath;
    private static String message;
    private static boolean errorFlag;
    private static final String SET_ENV_FILE = "metadata/setenv.txt";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void installPear(File localPearFile, File installationDir) {
        InstallationController.setLocalMode((boolean)true);
        InstallationDescriptorHandler installationDescriptorHandler = new InstallationDescriptorHandler();
        InstallPearSilently.printInConsole(false, "");
        if (localPearFile != null && !localPearFile.exists()) {
            errorFlag = true;
            message = localPearFile.getAbsolutePath() + "file not found \n";
            InstallPearSilently.printInConsole(errorFlag, message);
        } else if (localPearFile != null) {
            InstallPearSilently.printInConsole(false, "PEAR file to install is => " + localPearFile.getAbsolutePath() + "\n");
        }
        if (installationDir == null) {
            installationDir = new File("./");
        }
        InstallPearSilently.printInConsole(false, "Installation directory is => " + installationDir.getAbsolutePath() + "\n");
        try {
            JarFile jarFile = new JarFile(localPearFile);
            installationDescriptorHandler.parseInstallationDescriptor(jarFile);
            insdObject = installationDescriptorHandler.getInstallationDescriptor();
            if (insdObject == null) {
                throw new FileNotFoundException("installation descriptor not found \n");
            }
            mainComponentId = insdObject.getMainComponentId();
            if (insdObject.getDelegateComponents().size() > 0) {
                throw new RuntimeException("separate delegate components not supported \n");
            }
        }
        catch (Exception err) {
            errorFlag = true;
            message = " terminated \n" + err.toString();
            InstallPearSilently.printInConsole(errorFlag, message);
            return;
        }
        InstallationController installationController = new InstallationController(mainComponentId, localPearFile, installationDir);
        installationController.addMsgListener(new MessageRouter.StdChannelListener(){

            public void errMsgPosted(String errMsg) {
                InstallPearSilently.printInConsole(true, errMsg);
            }

            public void outMsgPosted(String outMsg) {
                InstallPearSilently.printInConsole(false, outMsg);
            }
        });
        insdObject = installationController.installComponent();
        if (insdObject == null) {
            errorFlag = true;
            message = " \nInstallation of " + mainComponentId + " failed => \n " + installationController.getInstallationMsg();
            InstallPearSilently.printInConsole(errorFlag, message);
        } else {
            try {
                installationController.saveInstallationDescriptorFile();
                mainComponentRootPath = insdObject.getMainComponentRoot();
                errorFlag = false;
                message = " \nInstallation of " + mainComponentId + " completed \n";
                InstallPearSilently.printInConsole(errorFlag, message);
                message = "The " + mainComponentRootPath + "/" + SET_ENV_FILE + " \n    file contains required " + "environment variables for this component\n";
                InstallPearSilently.printInConsole(errorFlag, message);
                if (installationController.verifyComponent()) {
                    errorFlag = false;
                    message = "Verification of " + mainComponentId + " completed \n";
                    InstallPearSilently.printInConsole(errorFlag, message);
                } else {
                    errorFlag = true;
                    message = "Verification of " + mainComponentId + " failed => \n " + installationController.getVerificationMsg();
                    InstallPearSilently.printInConsole(errorFlag, message);
                }
            }
            catch (Exception exc) {
                errorFlag = true;
                message = "Error in InstallationController.main(): " + exc.toString();
                InstallPearSilently.printInConsole(errorFlag, message);
            }
            finally {
                installationController.terminate();
            }
        }
    }

    private static void runCVD() {
        try {
            PackageBrowser pkgBrowser = new PackageBrowser(new File(mainComponentRootPath));
            String pearDesc = pkgBrowser.getComponentPearDescPath();
            MainFrame frame = CVD.createMainFrame();
            frame.setExitOnClose(false);
            frame.loadAEDescriptor(new File(pearDesc));
            frame.runAE(true);
        }
        catch (Throwable e) {
            InstallPearSilently.printInConsole(true, " Error in runCVD() " + e.toString());
            StringWriter strWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter((Writer)strWriter, true);
            e.printStackTrace(printWriter);
            printWriter.flush();
            strWriter.flush();
            InstallPearSilently.printInConsole(true, strWriter.toString());
        }
    }

    private static void printInConsole(boolean errorFlag, String message) {
        if (errorFlag) {
            System.err.println(message);
        } else {
            System.out.println(message);
        }
    }

    public static String getString(String[] a, int i) {
        try {
            return a[i];
        }
        catch (Exception e) {
            System.err.println();
            System.err.println("Error accessing argument " + i);
            System.err.println("Number of arguments received = " + (a == null ? -1 : a.length));
            e.printStackTrace(System.err);
            return null;
        }
    }

    public static String quote(String s) {
        if (s == null) {
            return "[null]";
        }
        char DBLQUOTES = '\"';
        String QUOTE = "'";
        if (s.contains(QUOTE)) {
            return DBLQUOTES + s + DBLQUOTES;
        }
        return QUOTE + s + QUOTE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String pearFn = InstallPearSilently.getString(args, 0);
        String installDir = InstallPearSilently.getString(args, 1);
        if (pearFn == null || installDir == null) {
            System.err.println("Usage: java InstallPearSilently  filename.pear  directory/to/install/into <false>");
            System.exit(-1);
        }
        String arg2 = "false";
        try {
            arg2 = args[2];
        }
        catch (Exception e) {
            // empty catch block
        }
        boolean runCvd = Boolean.parseBoolean(arg2);
        localTearFile = new File(pearFn);
        installationDir = new File(installDir);
        RunInstallation runner = new RunInstallation(localTearFile, installationDir);
        Thread thread = new Thread(runner);
        thread.start();
        RunInstallation runInstallation = runner;
        synchronized (runInstallation) {
            try {
                runner.wait(500000L);
            }
            catch (InterruptedException ex) {
                errorFlag = true;
                message = "InterruptedException " + ex;
                InstallPearSilently.printInConsole(errorFlag, message);
            }
        }
        if (runCvd) {
            InstallPearSilently.runCVD();
        }
    }

    static {
        message = null;
        errorFlag = false;
    }

    protected static class RunInstallation
    implements Runnable {
        private File pearFile;
        private File installationDir = null;

        public RunInstallation(File pearFile, File installationDir) {
            this.pearFile = pearFile;
            this.installationDir = installationDir;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            InstallPearSilently.installPear(this.pearFile, this.installationDir);
            RunInstallation runInstallation = this;
            synchronized (runInstallation) {
                this.notifyAll();
            }
        }
    }
}

