/*
 * Decompiled with CFR 0.152.
 */
package org.exquery.restxq.impl;

import java.net.URI;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.exquery.http.HttpMethod;
import org.exquery.http.HttpRequest;
import org.exquery.restxq.RestXqService;
import org.exquery.restxq.RestXqServiceRegistry;
import org.exquery.restxq.RestXqServiceRegistryListener;
import org.exquery.restxq.impl.RestXqServicesMap;

public class RestXqServiceRegistryImpl
implements RestXqServiceRegistry {
    private final RestXqServicesMap services = new RestXqServicesMap();
    private final List<RestXqServiceRegistryListener> listeners = new ArrayList<RestXqServiceRegistryListener>();

    private RestXqServicesMap getServices() {
        return this.services;
    }

    public void register(RestXqService service) {
        EnumSet servicedMethods = service.getServicedMethods();
        if (!servicedMethods.isEmpty()) {
            for (HttpMethod servicedMethod : servicedMethods) {
                this.getServices().put(servicedMethod, service);
                for (RestXqServiceRegistryListener listener : this.listeners) {
                    listener.registered(service);
                }
            }
        }
    }

    public void register(Iterable<RestXqService> services) {
        for (RestXqService service : services) {
            this.register(service);
        }
    }

    public Iterator<RestXqService> iterator() {
        final HashSet uniqueServices = new HashSet();
        RestXqServicesMap.RestXqServiceMapVisitor visitor = new RestXqServicesMap.RestXqServiceMapVisitor(){

            @Override
            public void visit(HttpMethod method, List<RestXqService> restXqServices) {
                uniqueServices.addAll(restXqServices);
            }
        };
        this.getServices().iterate(visitor, true);
        return uniqueServices.iterator();
    }

    public RestXqService findService(HttpRequest request) {
        return this.getServices().get(request.getMethod(), request);
    }

    public void deregister(URI xqueryLocation) {
        this.getServices().removeAll(xqueryLocation, this.listeners);
    }

    public void deregister(RestXqService service) {
        this.getServices().remove(service, this.listeners);
    }

    public void addListener(RestXqServiceRegistryListener listener) {
        this.listeners.add(listener);
    }

    public boolean removeListener(RestXqServiceRegistryListener listener) {
        return this.listeners.remove(listener);
    }

    public void clearListeners() {
        this.listeners.clear();
    }
}

